import Auth from '../../../auth/Auth';
import AuthState from '../../../auth/AuthState';
import { getRoles, getUserSettings } from '../../../api/internal';
import { fetchFavoriteProjects } from '../../../api/favoriteProjects';
import { FINISH_TO_LOAD_USER_SETTINGS } from './userSettings';
import { FAVORITE_PROJECTS_LOADED } from '../projects/favoriteProjects';

const START_TO_LOAD_USER_INFO = 'START_TO_LOAD_USER_INFO';
const FINISH_TO_LOAD_USER_INFO = 'FINISH_TO_LOAD_USER_INFO';
const FAILED_TO_LOAD_USER_INFO = 'FAILED_TO_LOAD_USER_INFO';

const RESTART_INTERVAL_MS = 60000;

export const loadUserInfo = () => (dispatch) => {
  dispatch({ type: START_TO_LOAD_USER_INFO });

  return Promise.all([getRoles(), getUserSettings(), fetchFavoriteProjects()])
    .then((responses) => {
      const roles = responses[0];
      const userSettings = responses[1];
      const favoriteProjects = responses[2];

      dispatch({ type: FINISH_TO_LOAD_USER_INFO, payload: roles });
      dispatch({ type: FINISH_TO_LOAD_USER_SETTINGS, payload: userSettings });
      dispatch({ type: FAVORITE_PROJECTS_LOADED, payload: favoriteProjects });
    })
    .catch((response) => {
      window.setTimeout(() => dispatch(loadUserInfo()), RESTART_INTERVAL_MS);
      console.error('failed to load user info', response);
      dispatch({ type: FAILED_TO_LOAD_USER_INFO, payload: response });
    });
};

const DEFAULT_STATE = {
  loading: true,
  data: null,
  error: null,
};

export const userInfoReducer = (state = DEFAULT_STATE, action) => {
  switch (action.type) {
    case START_TO_LOAD_USER_INFO:
      return { ...state, loading: true };
    case FINISH_TO_LOAD_USER_INFO: {
      const result = action.payload;
      Auth.setState(new AuthState(result.login, result.roles));
      return { loading: false, data: action.payload, error: null };
    }
    case FAILED_TO_LOAD_USER_INFO:
      return { loading: false, data: null, error: action.payload };
    default:
      return state;
  }
};
