import * as API from '../../../api/internal';
import { addDangerAlert } from '../toaster';

const START_TO_LOAD_USER_SETTINGS = 'START_TO_LOAD_USER_SETTINGS';
export const FINISH_TO_LOAD_USER_SETTINGS = 'FINISH_TO_LOAD_USER_SETTINGS';
const FAILED_TO_LOAD_USER_SETTINGS = 'FAILED_TO_LOAD_USER_SETTINGS';
const UPDATE_USER_SETTINGS = 'UPDATE_USER_SETTINGS';
const DISABLE_NEW_UI_ALERT_SETTING = 'DISABLE_NEW_UI_ALERT_SETTING';

export const loadUserSettings = () => (dispatch) => {
  dispatch({ type: START_TO_LOAD_USER_SETTINGS });

  return API.getUserSettings()
    .then(
      (resp) => dispatch({ type: FINISH_TO_LOAD_USER_SETTINGS, payload: resp }),
      (resp) => dispatch({ type: FAILED_TO_LOAD_USER_SETTINGS, payload: resp.message || '' }),
    );
};

export const updateUserSettings = (settings) => (dispatch) => API.updateUserSettings(settings)
  .then(
    (resp) => dispatch({ type: UPDATE_USER_SETTINGS, payload: resp }),
    (resp) => dispatch(addDangerAlert(resp.message)),
  );

export const disableNewUiAlert = () => (dispatch) => API.updateUserSetting('experimentalShowNewUiAlert', 'false')
  .then(
    (resp) => dispatch({ type: DISABLE_NEW_UI_ALERT_SETTING, payload: resp }),
    (resp) => dispatch(addDangerAlert(resp.message)),
  );

const DEFAULT_STATE = {
  loading: false,
  data: null,
  error: null,
};

export const userSettingsReducer = (state = DEFAULT_STATE, action) => {
  switch (action.type) {
    case START_TO_LOAD_USER_SETTINGS:
      return { loading: true, data: state.data, error: null };
    case FINISH_TO_LOAD_USER_SETTINGS:
    case UPDATE_USER_SETTINGS:
      return { loading: false, data: action.payload, error: null };
    case FAILED_TO_LOAD_USER_SETTINGS:
      return { loading: false, data: null, error: action.payload };
    case DISABLE_NEW_UI_ALERT_SETTING:
      return {
        loading: false,
        data: { ...state.data, settings: { ...state.data.settings, experimentalShowNewUiAlert: 'false' } },
        error: null,
      };
    default:
      return state;
  }
};
