import isEmpty from 'lodash/isEmpty';
import { addDangerAlert } from '../toaster';
import { fetchSelectorsFromParams } from './utils';

const DASHBOARD_PARAM_SENSORS_LOADED = 'DASHBOARD_PARAM_SENSORS_LOADED';
const DASHBOARD_PARAM_SENSORS_CLEARED = 'DASHBOARD_PARAM_SENSORS_CLEARED';

export const fetchDashboardParamSensors = (projectId, params) => (dispatch) => {
  const projectParams = params.filter((p) => p.name === 'project');
  const dataProjectId = projectParams.length > 0 ? projectParams[0].value : projectId;

  if (isEmpty(params)) {
    return dispatch({ type: DASHBOARD_PARAM_SENSORS_CLEARED });
  }
  return fetchSelectorsFromParams(dataProjectId, params)
    .then(
      (resp) => dispatch({ type: DASHBOARD_PARAM_SENSORS_LOADED, payload: resp }),
      (resp) => dispatch(addDangerAlert(resp.message)),
    );
};

export const dashboardParamSensorsPageReducer = (state = {}, action) => {
  switch (action.type) {
    case DASHBOARD_PARAM_SENSORS_LOADED:
      return action.payload;
    case DASHBOARD_PARAM_SENSORS_CLEARED:
      return {};
    default:
      return state;
  }
};
