import isEmpty from 'lodash/isEmpty';
import { addDangerAlert } from '../toaster';
import { fetchSelectorsFromParams } from './utils';

const GRAPH_PARAM_SENSORS_CLEARED = 'GRAPH_PARAM_SENSORS_CLEARED';
const GRAPH_PARAM_SENSORS_LOADED = 'GRAPH_PARAM_SENSORS_LOADED';

export const fetchGraphParamSensors = (projectId, params) => (dispatch) => {
  const projectParams = params.filter((p) => p.name === 'project');
  const dataProjectId = projectParams.length > 0 ? projectParams[0].value : projectId;

  if (isEmpty(params)) {
    return dispatch({ type: GRAPH_PARAM_SENSORS_CLEARED });
  }
  return fetchSelectorsFromParams(dataProjectId, params)
    .then(
      (resp) => dispatch({ type: GRAPH_PARAM_SENSORS_LOADED, payload: resp }),
      (resp) => dispatch(addDangerAlert(resp.message)),
    );
};

export const graphParamSensorsPageReducer = (state = {}, action) => {
  switch (action.type) {
    case GRAPH_PARAM_SENSORS_LOADED:
      return action.payload;
    case GRAPH_PARAM_SENSORS_CLEARED:
      return {};
    default:
      return state;
  }
};
