import { formatOldSelectorEntriesAsNewSelectors } from '../../../utils/SelectorUtils';
import * as API from '../../../api/sensors';

export function fetchSelectorsFromParams(projectId, params) {
  const selectors = formatOldSelectorEntriesAsNewSelectors(params.map((p) => [p.name, p.value]));
  return API.fetchSensors(projectId, { selectors, pageSize: 1 }, false);
}

export default {
  fetchSelectorsFromParams,
};
