import * as API from '../../../api/favoriteProjects';
import { addDangerAlert } from '../toaster';

export const FAVORITE_PROJECTS_LOADED = 'favoriteProjects/LOADED';
const FAVORITE_PROJECT_SAVED = 'favoriteProjects/SAVED';
const FAVORITE_PROJECT_DELETED = 'favoriteProjects/DELETED';

export const saveFavoriteProject = (projectId) => (dispatch) =>
  API.createFavoriteProject(projectId)
    .then((resp) => dispatch({
      type: FAVORITE_PROJECT_SAVED,
      payload: resp,
    }),
    (resp) => dispatch(addDangerAlert(resp.message)));

export const deleteFavoriteProject = (projectId) => (dispatch) =>
  API.deleteFavoriteProject(projectId)
    .then(
      () => dispatch({ type: FAVORITE_PROJECT_DELETED, payload: projectId }),
      (resp) => dispatch(addDangerAlert(resp.message)),
    );

const DEFAULT_STATE = {
  ids: [],
  projects: [],
};

export const favoriteProjectReducer = (state = DEFAULT_STATE, action) => {
  switch (action.type) {
    case FAVORITE_PROJECTS_LOADED: {
      const projects = action.payload.result || [];
      const ids = projects.map((fav) => fav.id);
      return { ids, projects };
    }
    case FAVORITE_PROJECT_SAVED: {
      const project = action.payload;
      const projectId = project.id;
      if (state.ids.indexOf(projectId) >= 0) {
        return state;
      }

      const newProjects = [...state.projects];
      newProjects.push(project);
      // eslint-disable-next-line no-nested-ternary
      newProjects.sort((a, b) => (a.id < b.id ? -1 : (a.id > b.id ? 1 : 0)));

      const newIds = newProjects.map((prj) => prj.id);

      return {
        ids: newIds,
        projects: newProjects,
      };
    }
    case FAVORITE_PROJECT_DELETED: {
      const projectId = action.payload;
      const projectIdx = state.ids.indexOf(projectId);
      if (projectIdx < 0) {
        return state;
      }
      const newIds = [...state.ids];
      const newProjects = [...state.projects];
      newIds.splice(projectIdx, 1);
      newProjects.splice(projectIdx, 1);

      return {
        ids: newIds,
        projects: newProjects,
      };
    }
    default:
      return state;
  }
};
