import * as API from '../../../api/internal';

const PROJECT_FEATURE_FLAGS_GET = 'PROJECT_FEATURE_FLAGS_GET';

export function getProjectFeatureFlags(projectId) {
  return async (dispatch) => {
    const featureFlags = await API.getFeatureFlags(projectId);

    dispatch({
      type: PROJECT_FEATURE_FLAGS_GET,
      payload: featureFlags,
    });
  };
}

export const projectFeatureFlagsReducer = (state = {}, action) => {
  switch (action.type) {
    case PROJECT_FEATURE_FLAGS_GET:
      return action.payload;
    default:
      return state;
  }
};
