import * as API from '../../../api/internal';

const PROJECT_IDM_ROLES_GET = 'PROJECT_IDM_ROLES_GET';

export const getProjectIdmRoles = (projectId) => (dispatch) => API.getProjectIdmRoles(projectId)
  .then(
    (resp) => dispatch({ type: PROJECT_IDM_ROLES_GET, payload: resp.projectRoles || [] }),
  );

export const projectIdmRolesReducer = (state = [], action) => {
  switch (action.type) {
    case PROJECT_IDM_ROLES_GET:
      return action.payload;
    default:
      return state;
  }
};
