import * as API from '../../../api/projectMenus';
import { addDangerAlert } from '../toaster';

const PROJECT_MENU_FOUND = 'PROJECT_MENU_FOUND';
const PROJECT_MENU_SAVED = 'PROJECT_MENU_SAVED';

export const findProjectMenu = (projectId) => (dispatch) => API.fetchProjectMenu(projectId)
  .then(
    (resp) => dispatch({ type: PROJECT_MENU_FOUND, payload: resp }),
    (resp) => dispatch(addDangerAlert(resp.message)),
  );

export const saveProjectMenu = (projectId, projectMenu) => (dispatch) =>
  API.saveProjectMenu(projectId, projectMenu)
    .then(
      () => dispatch({ type: PROJECT_MENU_SAVED }),
      (resp) => dispatch(addDangerAlert(resp.message)),
    );

export const projectMenuReducer = (state = {}, action) => {
  switch (action.type) {
    case PROJECT_MENU_FOUND:
      return action.payload;
    case PROJECT_MENU_SAVED:
      return {};
    default:
      return state;
  }
};
