import * as API from '../../../api/projects';
import { addDangerAlert } from '../toaster';

const PROJECTS_LOADED = 'PROJECTS_LOADED';

export const fetchProjects = (params) => (dispatch) => API.fetchAllProjects(params)
  .then(
    (resp) => dispatch({ type: PROJECTS_LOADED, payload: resp }),
    (resp) => dispatch(addDangerAlert(resp.message)),
  );

export const projectsReducer = (state = {}, action) => {
  switch (action.type) {
    case PROJECTS_LOADED:
      return action.payload;
    default:
      return state;
  }
};
