import * as API from '../../../api/sensors';
import { addDangerAlert } from '../toaster';

const SENSORS_LOADED = 'SENSORS_LOADED';
const CLEAR_SENSORS = 'CLEAR_SENSORS';

export const fetchSensors = (projectId, params, useNewFormat) => (dispatch) =>
  API.fetchSensors(projectId, params, useNewFormat)
    .then(
      (resp) => dispatch({ type: SENSORS_LOADED, payload: resp }),
      (resp) => dispatch(addDangerAlert(resp.message)),
    );

export const clearSensors = () => (dispatch) => dispatch({ type: CLEAR_SENSORS });

export const sensorsPageReducer = (state = {}, action) => {
  switch (action.type) {
    case SENSORS_LOADED:
      return action.payload;
    case CLEAR_SENSORS:
      return {};
    default:
      return state;
  }
};
