import * as API from '../../../api/serviceDashboards';
import { addDangerAlert } from '../toaster';

const START_TO_LOAD_SERVICE_DASHBOARD = 'START_TO_LOAD_SERVICE_DASHBOARD';
const FINISH_TO_LOAD_SERVICE_DASHBOARD = 'FINISH_TO_LOAD_SERVICE_DASHBOARD';
const FAILED_TO_LOAD_SERVICE_DASHBOARD = 'FAILED_TO_LOAD_SERVICE_DASHBOARD';

const SAVE_SERVICE_DASHBOARD = 'SAVE_SERVICE_DASHBOARD';
const DELETE_SERVICE_DASHBOARD = 'DELETE_SERVICE_DASHBOARD';
const CLEAR_SERVICE_DASHBOARD = 'CLEAR_SERVICE_DASHBOARD';
const VALIDATE_SERVICE_DASHBOARD = 'VALIDATE_SERVICE_DASHBOARD';

export const loadServiceDashboard = (id) => (dispatch) => {
  const hash = Date.now();

  dispatch({ type: START_TO_LOAD_SERVICE_DASHBOARD, payload: hash });

  return API.fetchServiceDashboard(id)
    .then(
      (resp) => dispatch({
        type: FINISH_TO_LOAD_SERVICE_DASHBOARD,
        payload: { result: resp, hash },
      }),
      (resp) => dispatch({
        type: FAILED_TO_LOAD_SERVICE_DASHBOARD,
        payload: { result: resp.message, hash },
      }),
    );
};

export const saveServiceDashboard = (serviceDashboard, isNew) => (dispatch) => {
  const promise = isNew
    ? API.createServiceDashboard(serviceDashboard)
    : API.updateServiceDashboard(serviceDashboard);

  promise
    .then(
      (resp) => dispatch({ type: SAVE_SERVICE_DASHBOARD, payload: resp }),
      (resp) => dispatch(addDangerAlert(resp.message)),
    );

  return promise;
};

export const validateServiceDashboard = (serviceDashboard) => (dispatch) => {
  const promise = API.validateServiceDashboard(serviceDashboard);
  promise
    .then(
      (resp) => dispatch({ type: VALIDATE_SERVICE_DASHBOARD, payload: resp }),
      (resp) => dispatch(addDangerAlert(resp.message)),
    );

  return promise;
};

export const validateServiceDashboardSync = (serviceDashboardId, dashboardId) => (dispatch) => {
  const promise = API.validateServiceDashboardSync(serviceDashboardId, dashboardId);
  promise
    .then(
      (resp) => dispatch({ type: VALIDATE_SERVICE_DASHBOARD, payload: resp }),
      (resp) => dispatch(addDangerAlert(resp.message)),
    );

  return promise;
};

export const syncServiceDashboard = (serviceDashboardId, dashboardId, link) => (dispatch) =>
  API.syncServiceDashboard(serviceDashboardId, dashboardId, link)
    .then(
      (resp) => dispatch({ type: SAVE_SERVICE_DASHBOARD, payload: resp }),
      (resp) => dispatch(addDangerAlert(resp.message)),
    );

export const deleteServiceDashboard = (id) => (dispatch) =>
  API.deleteServiceDashboard(id)
    .then(
      () => dispatch({ type: DELETE_SERVICE_DASHBOARD }),
      (resp) => dispatch(addDangerAlert(resp.message)),
    );

export const clearServiceDashboard = () => (dispatch) =>
  dispatch({ type: CLEAR_SERVICE_DASHBOARD });

export const serviceDashboardReducer = (state = {}, action) => {
  switch (action.type) {
    case START_TO_LOAD_SERVICE_DASHBOARD:
      return {
        loading: true, hash: action.payload, data: null, error: null,
      };
    case FINISH_TO_LOAD_SERVICE_DASHBOARD:
      if (state.hash !== action.payload.hash) {
        return state;
      }
      return {
        loading: false, hash: '', data: action.payload.result, error: null,
      };
    case FAILED_TO_LOAD_SERVICE_DASHBOARD:
      if (state.hash !== action.payload.hash) {
        return state;
      }
      return {
        loading: false, hash: '', data: null, error: action.payload.result,
      };
    case SAVE_SERVICE_DASHBOARD:
      return {
        loading: false, hash: '', data: action.payload, error: null,
      };
    default:
      return state;
  }
};

export const serviceDashboardValidationResultReducer = (state = {}, action) => {
  switch (action.type) {
    case VALIDATE_SERVICE_DASHBOARD: {
      return action.payload;
    }
    default:
      return state;
  }
};
