import * as API from '../../../api/serviceDashboards';

const START_TO_LOAD_SERVICE_DASHBOARDS = 'START_TO_LOAD_SERVICE_DASHBOARDS';
const FINISH_TO_LOAD_SERVICE_DASHBOARDS = 'FINISH_TO_LOAD_SERVICE_DASHBOARDS';
const FAILED_TO_LOAD_SERVICE_DASHBOARDS = 'FAILED_TO_LOAD_SERVICE_DASHBOARDS';
const CLEAR_SERVICE_DASHBOARDS = 'CLEAR_SERVICE_DASHBOARDS';

export const loadServiceDashboards = (urlParams) => (dispatch) => {
  const hash = Date.now();

  dispatch({ type: START_TO_LOAD_SERVICE_DASHBOARDS, payload: hash });

  return API.fetchServiceDashboards(urlParams)
    .then(
      (resp) => dispatch({
        type: FINISH_TO_LOAD_SERVICE_DASHBOARDS,
        payload: { result: resp, hash },
      }),
      (resp) => dispatch({
        type: FAILED_TO_LOAD_SERVICE_DASHBOARDS,
        payload: { result: resp.message, hash },
      }),
    );
};

const DEFAULT_STATE = {
  loading: false, hash: null, data: null, error: null,
};

export const clearServiceDashboards = () => (dispatch) =>
  dispatch({ type: CLEAR_SERVICE_DASHBOARDS });

export const serviceDashboardsPageReducer = (state = {}, action) => {
  switch (action.type) {
    case START_TO_LOAD_SERVICE_DASHBOARDS:
      return {
        loading: true, hash: action.payload, data: null, error: null,
      };
    case FINISH_TO_LOAD_SERVICE_DASHBOARDS:
      if (state.hash !== action.payload.hash) {
        return state;
      }
      return {
        loading: false, hash: '', data: action.payload.result, error: null,
      };
    case FAILED_TO_LOAD_SERVICE_DASHBOARDS:
      if (state.hash !== action.payload.hash) {
        return state;
      }
      return {
        loading: false, hash: '', data: null, error: action.payload.result,
      };
    case CLEAR_SERVICE_DASHBOARDS:
      return DEFAULT_STATE;
    default:
      return state;
  }
};
