import * as API from '../../../api/serviceProviders';
import { addDangerAlert } from '../toaster';

const START_TO_LOAD_SERVICE_PROVIDER = 'START_TO_LOAD_SERVICE_PROVIDER';
const FINISH_TO_LOAD_SERVICE_PROVIDER = 'FINISH_TO_LOAD_SERVICE_PROVIDER';
const FAILED_TO_LOAD_SERVICE_PROVIDER = 'FAILED_TO_LOAD_SERVICE_PROVIDER';

const SAVE_SERVICE_PROVIDER = 'SAVE_SERVICE_PROVIDER';
const DELETE_SERVICE_PROVIDER = 'DELETE_SERVICE_PROVIDER';
const CLEAR_SERVICE_PROVIDER = 'CLEAR_SERVICE_PROVIDER';

export const loadServiceProvider = (id) => (dispatch) => {
  const hash = Date.now();

  dispatch({ type: START_TO_LOAD_SERVICE_PROVIDER, payload: hash });

  return API.fetchServiceProvider(id)
    .then(
      (resp) => dispatch({
        type: FINISH_TO_LOAD_SERVICE_PROVIDER,
        payload: { result: resp, hash },
      }),
      (resp) => dispatch({
        type: FAILED_TO_LOAD_SERVICE_PROVIDER,
        payload: { result: resp.message, hash },
      }),
    );
};

export const saveServiceProvider = (serviceProvider, isNew) => (dispatch) => {
  const promise = isNew
    ? API.createServiceProvider(serviceProvider)
    : API.updateServiceProvider(serviceProvider);

  promise
    .then(
      (resp) => dispatch({ type: SAVE_SERVICE_PROVIDER, payload: resp }),
      (resp) => dispatch(addDangerAlert(resp.message)),
    );

  return promise;
};

export const deleteServiceProvider = (id) => (dispatch) => API.deleteServiceProvider(id)
  .then(
    () => dispatch({ type: DELETE_SERVICE_PROVIDER }),
    (resp) => dispatch(addDangerAlert(resp.message)),
  );

export const clearServiceProvider = () => (dispatch) => dispatch({ type: CLEAR_SERVICE_PROVIDER });

export const serviceProviderReducer = (state = {}, action) => {
  switch (action.type) {
    case START_TO_LOAD_SERVICE_PROVIDER:
      return {
        loading: true, hash: action.payload, data: null, error: null,
      };
    case FINISH_TO_LOAD_SERVICE_PROVIDER:
      if (state.hash !== action.payload.hash) {
        return state;
      }
      return {
        loading: false, hash: '', data: action.payload.result, error: null,
      };
    case FAILED_TO_LOAD_SERVICE_PROVIDER:
      if (state.hash !== action.payload.hash) {
        return state;
      }
      return {
        loading: false, hash: '', data: null, error: action.payload.result,
      };
    default:
      return state;
  }
};
