import * as API from '../../../api/serviceProviders';

const START_TO_LOAD_SERVICE_PROVIDERS = 'START_TO_LOAD_SERVICE_PROVIDERS';
const FINISH_TO_LOAD_SERVICE_PROVIDERS = 'FINISH_TO_LOAD_SERVICE_PROVIDERS';
const FAILED_TO_LOAD_SERVICE_PROVIDERS = 'FAILED_TO_LOAD_SERVICE_PROVIDERS';
const CLEAR_SERVICE_PROVIDERS = 'CLEAR_SERVICE_PROVIDERS';

export const loadServiceProviders = (urlParams) => (dispatch) => {
  const hash = Date.now();

  dispatch({ type: START_TO_LOAD_SERVICE_PROVIDERS, payload: hash });

  return API.fetchServiceProviders(urlParams)
    .then(
      (resp) => dispatch({
        type: FINISH_TO_LOAD_SERVICE_PROVIDERS,
        payload: { result: resp, hash },
      }),
      (resp) => dispatch({
        type: FAILED_TO_LOAD_SERVICE_PROVIDERS,
        payload: { result: resp.message, hash },
      }),
    );
};

const DEFAULT_STATE = {
  loading: false, hash: null, data: null, error: null,
};

export const clearServiceProviders = () => (dispatch) =>
  dispatch({ type: CLEAR_SERVICE_PROVIDERS });

export const serviceProvidersPageReducer = (state = {}, action) => {
  switch (action.type) {
    case START_TO_LOAD_SERVICE_PROVIDERS:
      return {
        loading: true, hash: action.payload, data: null, error: null,
      };
    case FINISH_TO_LOAD_SERVICE_PROVIDERS:
      if (state.hash !== action.payload.hash) {
        return state;
      }
      return {
        loading: false, hash: '', data: action.payload.result, error: null,
      };
    case FAILED_TO_LOAD_SERVICE_PROVIDERS:
      if (state.hash !== action.payload.hash) {
        return state;
      }
      return {
        loading: false, hash: '', data: null, error: action.payload.result,
      };
    case CLEAR_SERVICE_PROVIDERS:
      return DEFAULT_STATE;
    default:
      return state;
  }
};
