import * as API from '../../../api/services';
import { addDangerAlert } from '../toaster';

const START_TO_LOAD_GLOBAL_SERVICES = 'START_TO_LOAD_GLOBAL_SERVICES';
const FINISH_TO_LOAD_GLOBAL_SERVICES = 'FINISH_TO_LOAD_GLOBAL_SERVICES';
const FAILED_TO_LOAD_GLOBAL_SERVICES = 'FAILED_TO_LOAD_GLOBAL_SERVICES';
const CLEAR_GLOBAL_SERVICES = 'CLEAR_GLOBAL_SERVICES';

export const findGlobalServices = (params) => (dispatch) => {
  dispatch({ type: START_TO_LOAD_GLOBAL_SERVICES });

  return API.fetchGlobalServices(params)
    .then(
      (resp) => dispatch({ type: FINISH_TO_LOAD_GLOBAL_SERVICES, payload: resp }),
      (resp) => {
        dispatch({ type: FAILED_TO_LOAD_GLOBAL_SERVICES, payload: resp });
        dispatch(addDangerAlert(resp.message));
      },
    );
};

export const clearGlobalServices = () => (dispatch) => dispatch({ type: CLEAR_GLOBAL_SERVICES });

const DEFAULT_GLOBAL_SERVICES_STATE = {
  loading: false,
  data: null,
  error: null,
};

export const globalServicesPageReducer = (state = DEFAULT_GLOBAL_SERVICES_STATE, action) => {
  switch (action.type) {
    case START_TO_LOAD_GLOBAL_SERVICES:
      return { loading: true, data: state.data, error: null };
    case FINISH_TO_LOAD_GLOBAL_SERVICES:
      return { loading: false, data: action.payload, error: null };
    case FAILED_TO_LOAD_GLOBAL_SERVICES:
      return { loading: false, data: null, error: action.payload };
    case CLEAR_GLOBAL_SERVICES:
      return DEFAULT_GLOBAL_SERVICES_STATE;
    default:
      return state;
  }
};
