import * as API from '../../../api/services';
import { addDangerAlert } from '../toaster';

const SERVICE_FOUND = 'SERVICE_FOUND';
const SERVICE_SAVED = 'SERVICE_SAVED';
const SERVICE_DELETED = 'SERVICE_DELETED';
const SERVICE_CLEAR = 'SERVICE_CLEAR';

export const findService = (projectId, serviceId) => (dispatch) =>
  API.fetchService(projectId, serviceId)
    .then(
      (resp) => dispatch({ type: SERVICE_FOUND, payload: resp }),
      (resp) => dispatch(addDangerAlert(resp.message)),
    );

export const saveService = (projectId, service, isNew) => (dispatch) => {
  const promise = isNew
    ? API.createService(projectId, service)
    : API.updateService(projectId, service);
  promise.then(
    () => dispatch({ type: SERVICE_SAVED }),
    (resp) => dispatch(addDangerAlert(resp.message)),
  );
  return promise;
};

export const deleteService = (projectId, serviceId) => (dispatch) =>
  API.deleteService(projectId, serviceId)
    .then(
      () => dispatch({ type: SERVICE_DELETED }),
      (resp) => dispatch(addDangerAlert(resp.message)),
    );

export const clearService = () => (dispatch) => dispatch({ type: SERVICE_CLEAR });

export const serviceReducer = (state = {}, action) => {
  switch (action.type) {
    case SERVICE_FOUND:
      return action.payload;
    case SERVICE_SAVED:
    case SERVICE_DELETED:
    case SERVICE_CLEAR:
      return {};
    default:
      return state;
  }
};
