import * as API from '../../../api/services';
import { addDangerAlert } from '../toaster';

const SERVICE_CLUSTERS_FOUND = 'SERVICE_CLUSTERS_FOUND';

export const findServiceClusters = (projectId, serviceId) => (dispatch) =>
  API.fetchServiceClusters(projectId, serviceId)
    .then(
      (resp) => dispatch({ type: SERVICE_CLUSTERS_FOUND, payload: resp }),
      (resp) => dispatch(addDangerAlert(resp.message)),
    );

export const serviceClustersReducer = (state = [], action) => {
  switch (action.type) {
    case SERVICE_CLUSTERS_FOUND:
      return action.payload;
    default:
      return state;
  }
};
