import * as API from '../../../api/services';
import { addDangerAlert } from '../toaster';

const SERVICES_FOUND = 'SERVICES_FOUND';

export const findProjectServices = (projectId, params) => (dispatch) =>
  API.fetchProjectServices(projectId, params)
    .then(
      (resp) => dispatch({ type: SERVICES_FOUND, payload: resp }),
      (resp) => dispatch(addDangerAlert(resp.message)),
    );

export const servicesPageReducer = (state = {}, action) => {
  switch (action.type) {
    case SERVICES_FOUND:
      return action.payload;
    default:
      return state;
  }
};
