import * as API from '../../../api/shards';
import { addDangerAlert } from '../toaster';

const GLOBAL_SHARDS_PAGE_FOUND = 'GLOBAL_SHARDS_PAGE_FOUND';

export const findGlobalShards = (params) => (dispatch) => API.fetchGlobalShards(params)
  .then(
    (resp) => dispatch({ type: GLOBAL_SHARDS_PAGE_FOUND, payload: resp }),
    (resp) => dispatch(addDangerAlert(resp.message)),
  );

export const globalShardsPageReducer = (state = {}, action) => {
  switch (action.type) {
    case GLOBAL_SHARDS_PAGE_FOUND:
      return action.payload;
    default:
      return state;
  }
};
