import * as API from '../../../api/shards';
import { addDangerAlert } from '../toaster';

const SHARD_TARGETS_STATUS_FOUND = 'SHARD_TARGETS_STATUS_FOUND';

export const findShardTargetsStatus = (projectId, shardId, params) => (dispatch) =>
  API.fetchShardTargetsStatus(projectId, shardId, params)
    .then(
      (resp) => dispatch({ type: SHARD_TARGETS_STATUS_FOUND, payload: resp }),
      (resp) => dispatch(addDangerAlert(resp.message)),
    );

export const shardTargetsStatusPageReducer = (state = {}, action) => {
  switch (action.type) {
    case SHARD_TARGETS_STATUS_FOUND:
      return action.payload;
    default:
      return state;
  }
};
