import * as API from '../../../api/shards';
import { addDangerAlert } from '../toaster';

const SHARDS_PAGE_FOUND = 'SHARDS_PAGE_FOUND';

export const findProjectShards = (projectId, params) => (dispatch) =>
  API.fetchProjectShards(projectId, params)
    .then(
      (resp) => dispatch({ type: SHARDS_PAGE_FOUND, payload: resp }),
      (resp) => dispatch(addDangerAlert(resp.message)),
    );

export const shardsPageReducer = (state = {}, action) => {
  switch (action.type) {
    case SHARDS_PAGE_FOUND:
      return action.payload;
    default:
      return state;
  }
};
