const ALERT_ADD = 'ALERT_ADD';
const ALERT_REMOVE = 'ALERT_REMOVE';

const addAction = (id, message, type) => ({
  type: ALERT_ADD,
  payload: { id, message, type },
});

const uniqueId = () => new Date().getTime();

export const removeAlert = (id) => ({ type: ALERT_REMOVE, payload: id });

export const addAlert = (message, type, delay = 5000) => (dispatch) => {
  const id = uniqueId();
  if (delay > 0) {
    setTimeout(() => dispatch(removeAlert(id)), delay);
  }
  dispatch(addAction(id, message, type));
};

export const addDangerAlert = (message) => addAlert(message, 'danger');
export const addInfoAlert = (message) => addAlert(message, 'info');

export const alertsReducer = (state = [], action) => {
  switch (action.type) {
    case ALERT_ADD: {
      const alert = action.payload;
      return [alert, ...state];
    }
    case ALERT_REMOVE: {
      const alertId = action.payload;
      return state.filter((a) => a.id !== alertId);
    }
    default:
      return state;
  }
};
