import React from 'react';
import { connect } from 'react-redux';
import PropTypes from 'prop-types';

import { addAlert } from '../../store/reducers/toaster';
import AlertsList from '../../components/AlertsList';

const AlertsListDemo = ({ onAlert }) => (
  <div>
    <AlertsList />
    <div className="btn-group">
      <button type="button" className="btn btn-success" onClick={() => onAlert('success')}>Success</button>
      <button type="button" className="btn btn-info" onClick={() => onAlert('info')}>Info</button>
      <button type="button" className="btn btn-warning" onClick={() => onAlert('warning')}>Warning</button>
      <button type="button" className="btn btn-danger" onClick={() => onAlert('danger')}>Danger</button>
    </div>
  </div>
);

AlertsListDemo.propTypes = {
  onAlert: PropTypes.func.isRequired,
};

let counter = 0;

export default connect(
  (state) => ({
    alerts: state.alerts,
  }),
  (dispatch) => ({
    onAlert(type) {
      counter += 1;
      dispatch(addAlert(`sample alert #${counter} text!`, type));
    },
  }),
)(AlertsListDemo);
