/* eslint-disable jsx-a11y/label-has-for */
import React from 'react';
import PropTypes from 'prop-types';

import HighchartsChart from '../../components/HighchartsChart/HighchartsChart';
import { fixedSeries } from './data';

function dropTimestamps(line) {
  return { ...line, data: line.data.map((point) => point[1]) };
}

function extractTimestamps(line) {
  return line.data.map((point) => point[0]);
}

const HighchartsPerfDemo = ({ stacked, categorized }) => {
  const { highchartsLines } = fixedSeries;

  let categories;
  let series;

  if (categorized) {
    categories = extractTimestamps(highchartsLines[0]);
    series = highchartsLines.map((line) => dropTimestamps(line));
  } else {
    categories = null;
    series = highchartsLines;
  }

  series = series.map((s) => ({ ...s, dataGrouping: { enabled: false } }));

  const options = {
    title: '',
    series,
    xAxis: { type: 'datetime', gridLineWidth: 1, categories },
    yAxis: { title: '' },
    legend: {
      enabled: false,
    },
    chart: { height: '300px', type: stacked ? 'area' : 'line' },
    plotOptions: {
      area: {
        stacking: 'normal',
      },
      series: {
        animation: false,
        marker: {
          radius: 0,
        },
      },
    },
    tooltip: {
      backgroundColor: 'white',
      shared: true,
      split: false,
    },
    credits: {
      enabled: false,
    },
    time: {
      useUTC: false,
    },
  };

  return (
    <HighchartsChart options={options} />
  );
};

HighchartsPerfDemo.propTypes = {
  stacked: PropTypes.bool,
  categorized: PropTypes.bool,
};

HighchartsPerfDemo.defaultProps = {
  stacked: false,
  categorized: false,
};

export default HighchartsPerfDemo;
