/* eslint-disable jsx-a11y/label-has-for */
import React from 'react';
import PropTypes from 'prop-types';

import { startTimeMs, endTimeMs, fixedSeries } from './data';
import { createGraphData } from '../../api/experimentalApi/experimentalDataApi';
import Interpolate from '../../solomon-graph/stack/Interpolate';
import SensorsChecksSet from '../../pages/old/OldGraphPage/OldLegend/SensorsChecksSet';
import OldGraphWithLegend from '../../pages/old/OldGraphPage/OldGraphWithLegend';

const SimpleChartPerfDemo = ({ stacked }) => {
  const graphData = createGraphData(fixedSeries.lines, [null], stacked, Interpolate.LINEAR, false, 'avg', SensorsChecksSet.parse(''));
  const graphDataResult = {
    start: new Date(startTimeMs).toISOString(),
    end: new Date(endTimeMs).toISOString(),
    now: new Date(endTimeMs).toISOString(),
    graphConf: { graphMode: 'graph', stack: 'true' },
    graphData,
    health: {},
    // New in experimental mode
    noncriticalError: '',
    criticalErrors: [],
    columns: fixedSeries.columns,
    hideGraph: false,
  };

  const graphMetaData = { graphConf: { graphMode: 'graph', stack: 'true' } };

  const graphGraphData = {
    loading: false,
    data: graphDataResult,
  };

  return (
    <OldGraphWithLegend
      appElement={document.documentElement}
      graphOnly
      graphMetaData={graphMetaData}
      isLocal
      url="/?"
      graphData={graphGraphData}
      debug
    />
  );
};

SimpleChartPerfDemo.propTypes = {
  stacked: PropTypes.bool,
};

SimpleChartPerfDemo.defaultProps = {
  stacked: false,
};

export default SimpleChartPerfDemo;
