/* eslint-disable jsx-a11y/label-has-for */
import { fixSeries } from '../../utils/data';

export const startTimeMs = 100000;
export const endTimeMs = 120000;
export const stepMs = 20;
export const lineCount = 100;

function makeLineData() {
  const data = [];
  for (let i = 0; i < lineCount; ++i) {
    const timestamps = [];
    const values = [];
    for (let j = startTimeMs; j < endTimeMs; j += stepMs) {
      const value = Math.random() * 100;
      timestamps.push(j);
      values.push(value);
    }
    data.push({
      alias: `timeseries ${i}`,
      timestamps,
      values,
      refIndex: 0,
    });
  }
  return data;
}

export const fixedSeries = fixSeries(makeLineData(), {});

export default fixedSeries;
