/* eslint-disable import/no-extraneous-dependencies */
import React from 'react';
import { storiesOf } from '@storybook/react';
import HighchartsPerfDemo from './HighchartsPerfDemo';
import SimpleChartPerfDemo from './SimpleChartPerfDemo';
import Measurer from './Measurer';

function wrap(content) {
  return (arg) => (
    <Measurer title={arg.name}>
      {content}
    </Measurer>
  );
}

storiesOf('Chart perfomance', module)
  .add('Simple chart (lines)', wrap(<SimpleChartPerfDemo />))
  .add('Simple chart (stacked)', wrap(<SimpleChartPerfDemo stacked />))
  .add('Categorized Highcharts (lines)', wrap(<HighchartsPerfDemo categorized />))
  .add('Categorized Highcharts (stacked)', wrap(<HighchartsPerfDemo stacked categorized />))
  .add('Highcharts (lines)', wrap(<HighchartsPerfDemo />))
  .add('Highcharts (stacked)', wrap(<HighchartsPerfDemo stacked />));
