import React from 'react';
import { getColorsForNames, getAlexPetrovColorsForN } from '../../utils/color/colors';

const ROWS_COUNT = 100;
const COLOR_SCHEME_PARAMS = {
  type: 'gradient', green: '5', yellow: '20', red: '80', violet: '90',
};

const ColorsDemo = () => {
  const rows = [];

  const names = new Array(ROWS_COUNT).fill().map((_, index) => `${index}`);

  const alexPetrovColors = getAlexPetrovColorsForN(ROWS_COUNT);
  const gradientColors = getColorsForNames(names, { type: 'auto' });
  const complexGradientColors = getColorsForNames(names, COLOR_SCHEME_PARAMS);

  for (let i = 0; i < ROWS_COUNT; ++i) {
    const alexPetrovColor = alexPetrovColors[i];
    const gradientColor = gradientColors[i];
    const complexGradientColor = complexGradientColors[i];

    rows.push({ alexPetrovColor, gradientColor, complexGradientColor });
  }

  return (
    <table width="100%">
      <thead>
        <tr>
          <th>AlexPetrov</th>
          <th>Gradient</th>
          <th>Complex gradient</th>
        </tr>
      </thead>
      <tbody>
        {rows.map((row, index) => (
          // eslint-disable-next-line react/no-array-index-key
          <tr key={index}>
            <td style={{ background: row.alexPetrovColor }}>{index}</td>
            <td style={{ background: row.gradientColor }}>{index}</td>
            <td style={{ background: row.complexGradientColor }}>{index}</td>
          </tr>
        ))}
      </tbody>
    </table>
  );
};

export default ColorsDemo;
