/* eslint-disable max-classes-per-file */
import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';

import Datalist from '../../components/Datalist';
import FormCheckbox from '../../components/forms/FormCheckbox';
import FormElement from '../../components/forms/FormElement';

import './style.css';

const birdDatalist = [
  'canary', 'condor', 'crane', 'eagle', 'emu', 'falcon', 'flamingo', 'gull', 'hummingbird',
  'ibis', 'kingbird', 'longclaw', 'lorikeet', 'mockingbird', 'osprey', 'ostrich', 'owl',
  'parrot', 'partridge', 'penguin', 'pigeon', 'puffin', 'rook',
];

const userDatalist = ['jamel', 'nga', 'gordiychuk', 'nohttp', 'rorewillo'];

class BirdDatalist extends PureComponent {
  constructor(props) {
    super(props);
    this.state = { value: '' };
  }

  onChange = (event) => {
    this.setState({ value: event.target.value });
  };

  render() {
    const { value } = this.state;
    const filteredDatalist = value
      ? birdDatalist.filter((item) => item.indexOf(value) >= 0)
      : birdDatalist;

    const mappedDatalist = filteredDatalist.map((item) => ({ value: item }));

    return (
      <Datalist
        datalist={mappedDatalist}
        value={value}
        placeholder="Enter bird name..."
        onChange={this.onChange}
        disabled={this.props.disabled}
      />
    );
  }
}

BirdDatalist.propTypes = {
  disabled: PropTypes.bool.isRequired,
};

class BirdDatalistWithLimit extends PureComponent {
  constructor(props) {
    super(props);
    this.state = { value: '', showMore: true };
  }

  onChange = (event) => {
    this.setState({ value: event.target.value, showMore: true });
  };

  onShowMore = () => {
    this.setState({ showMore: false });
  };

  render() {
    const { limit, disabled } = this.props;
    const { value, showMore } = this.state;

    const filteredDatalist = value
      ? birdDatalist.filter((item) => item.indexOf(value) >= 0)
      : birdDatalist;

    const limitedDatalist = showMore
      ? filteredDatalist.filter((_, index) => index < limit)
      : filteredDatalist;

    const mappedDatalist = limitedDatalist.map((item) => ({ value: item }));

    if (showMore && filteredDatalist.length > limit) {
      mappedDatalist.push({
        value: '',
        content: (<span>Load more...</span>),
        onClick: this.onShowMore,
      });
    }

    return (
      <Datalist
        datalist={mappedDatalist}
        value={value}
        placeholder="Enter bird name..."
        onChange={this.onChange}
        disabled={disabled}
      />
    );
  }
}

BirdDatalistWithLimit.propTypes = {
  limit: PropTypes.number.isRequired,
  disabled: PropTypes.bool.isRequired,
};

class UserDatalist extends PureComponent {
  constructor(props) {
    super(props);
    this.state = { value: '' };
  }

  onChange = (event) => {
    this.setState({ value: event.target.value });
  };

  render() {
    const { value } = this.state;
    const filteredDatalist = value
      ? userDatalist.filter((item) => item.indexOf(value) >= 0)
      : userDatalist;

    const mappedDatalist = filteredDatalist.map((item) => ({
      value: item,
      content: (
        <div className="demo-userlist__item">
          <img
            className="demo-userlist__userpic" alt="userpic"
            src={`//center.yandex-team.ru/api/v1/user/${item}/avatar/100.jpg`}
          />
          <span className="demo-userlist__login">
            {item}
          </span>
        </div>
      ),
    }));

    return (
      <Datalist
        datalist={mappedDatalist}
        value={value}
        placeholder="Enter user name..."
        onChange={this.onChange}
        disabled={this.props.disabled}
      />
    );
  }
}

UserDatalist.propTypes = {
  disabled: PropTypes.bool.isRequired,
};

class DatalistDemo extends PureComponent {
  constructor(props) {
    super(props);
    this.state = { disabled: false };
  }

  onDisabledChange = (event) => {
    this.setState({ disabled: event.target.checked });
  };

  render() {
    const { disabled } = this.state;

    return (
      <div>
        <div className="form-horizontal">
          <FormElement label="Birds">
            <BirdDatalist disabled={disabled} />
          </FormElement>
          <FormElement label="Birds (with limit)">
            <BirdDatalistWithLimit limit={5} disabled={disabled} />
          </FormElement>
          <FormElement label="Users">
            <UserDatalist disabled={disabled} />
          </FormElement>
          <FormCheckbox
            name="disabled"
            label="Disable datalists"
            value={disabled}
            onChange={this.onDisabledChange}
          />
        </div>
      </div>
    );
  }
}

export default DatalistDemo;
