import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import LabelSelector from '../../components/LabelSelector/LabelSelector';

class AsyncDemo extends PureComponent {
  constructor(props) {
    super(props);
    this.state = { loading: false, options: [], value: props.value };
  }

  handleSelect = (text) => {
    this.setState({ value: text });
  };

  handleLoad = (options) => {
    let filteredOptions = this.props.options;

    if (options.filter) {
      const patterns = options.filter.split('|');
      filteredOptions = filteredOptions
        .filter((option) => patterns.some((pattern) => option.value.includes(pattern)));
    }

    if (!options.showAllLabels) {
      filteredOptions = filteredOptions.filter((_, i) => i < 10);
    }

    this.setState({ loading: true });

    window.setTimeout(() => this.setState({ loading: false, options: filteredOptions }), 1000);
  };

  render() {
    return (
      <LabelSelector
        isAsync
        name={this.props.name}
        value={this.state.value}
        dropPath=""
        options={this.state.options}
        loading={this.state.loading}
        onSelect={this.handleSelect}
        onLoad={this.handleLoad}
        showAllValues={false}
      />
    );
  }
}

AsyncDemo.propTypes = {
  name: PropTypes.string.isRequired,
  value: PropTypes.string.isRequired,
  options: PropTypes.array.isRequired,
};

export default AsyncDemo;
