import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import LabelSelector from '../../components/LabelSelector/LabelSelector';

class StaticDemo extends PureComponent {
  constructor(props) {
    super(props);
    this.state = { options: props.options, value: props.value };
  }

  handleSelect = (text) => {
    this.setState({ value: text });
  };

  handleLoad = (options) => {
    let filteredOptions = this.props.options;

    if (options.filter) {
      filteredOptions = filteredOptions.filter((option) => option.value.includes(options.filter));
    }

    this.setState({ options: filteredOptions });
  };

  handleDrop = () => {
    // eslint-disable-next-line no-alert
    window.alert('Drop selector');
  };

  render() {
    return (
      <LabelSelector
        name={this.props.name}
        value={this.state.value}
        dropPath=""
        options={this.state.options}
        onSelect={this.handleSelect}
        onLoad={this.handleLoad}
        showAllValues={false}
      />
    );
  }
}

StaticDemo.propTypes = {
  name: PropTypes.string.isRequired,
  value: PropTypes.string.isRequired,
  options: PropTypes.array.isRequired,
};

export default StaticDemo;
