/* eslint-disable import/no-extraneous-dependencies */
import React from 'react';
import { storiesOf } from '@storybook/react';
import StaticDemo from './StaticDemo';
import AsyncDemo from './AsyncDemo';

function createOption(value, fullPath, selected) {
  return { value, fullPath, selected };
}

function createOptions(count) {
  const options = [];

  for (let i = 0; i < count; ++i) {
    options.push(createOption(`option ${i}`, '', false));
  }

  return options;
}

const SEVERAL_OPTIONS = [
  createOption('cluster', '', true),
  createOption('Man', '', false),
  createOption('Myt', '', false),
  createOption('Sas', '', false),
  createOption('Vla', '', false),
];

const THOUSAND_OPTIONS = createOptions(1000);

storiesOf('Label selector', module)
  .add('Default', () => (
    <StaticDemo name="host" value="cluster" options={SEVERAL_OPTIONS} />
  ))
  .add('Too many options', () => (
    <StaticDemo name="option" value="option 0" options={THOUSAND_OPTIONS} />
  ))
  .add('Async options', () => (
    <AsyncDemo name="option" value="option 0" options={THOUSAND_OPTIONS} />
  ));
