import React, { PureComponent } from 'react';

import { EditableTable as PredicateRulesEdit } from '../../pages/alerts/components/PredicateRulesTable';

class PredicateRulesEditorDemo extends PureComponent {
  constructor(props) {
    super(props);
    this.state = {
      rules: [
        {
          thresholdType: 'COUNT', comparison: 'EQ', threshold: 0, targetStatus: 'NO_DATA',
        },
        {
          thresholdType: 'AT_LEAST_ONE', comparison: 'GT', threshold: 0.95, targetStatus: 'ALARM',
        },
        {
          thresholdType: 'AVG', comparison: 'GT', threshold: 0.1, targetStatus: 'WARN',
        },
      ],
    };
  }

  onDelete = (index) => {
    const rules = [...this.state.rules];
    rules.splice(index, 1);
    this.setState({ rules });
  };

  onUpdate = (index, rule) => {
    const rules = [...this.state.rules];
    if (index < 0) {
      rules.push(rule);
    } else {
      rules.splice(index, 1, rule);
    }
    this.setState({ rules });
  };

  onMove = (index, dir) => {
    const rules = [...this.state.rules];
    const other = index + dir;
    if (other < 0 || other >= rules.length) {
      return;
    }
    [rules[index], rules[other]] = [rules[other], rules[index]];
    this.setState({ rules });
  };

  render() {
    return (
      <PredicateRulesEdit
        predicateRules={this.state.rules || []}
        onDelete={this.onDelete}
        onUpdate={this.onUpdate}
        onMove={this.onMove}
      />
    );
  }
}

export default PredicateRulesEditorDemo;
