/* eslint-disable import/no-extraneous-dependencies */
import React from 'react';
import { storiesOf } from '@storybook/react';
import { ReadonlyTable as PredicateRulesView } from '../../pages/alerts/components/PredicateRulesTable';
import PredicateRulesEditorDemo from './EditableDemo';

storiesOf('Predicates', module)
  .add('Predicate rule viewer', () => {
    const predicateRulesList = [
      {
        thresholdType: 'COUNT', comparison: 'EQ', threshold: 0, targetStatus: 'NO_DATA',
      },
      {
        thresholdType: 'AT_LEAST_ONE', comparison: 'GT', threshold: 0.95, targetStatus: 'ALARM',
      },
      {
        thresholdType: 'AVG', comparison: 'GT', threshold: 0.1, targetStatus: 'WARN',
      },
    ];
    return <PredicateRulesView predicateRules={predicateRulesList} limit={2} />;
  })
  .add('Predicate rule editor', () => <PredicateRulesEditorDemo />);
