import React from 'react';
import MenuEditor from '../../components/MenuEditor/MenuEditor';

const treeData = [
  {
    title: 'Tx Processing',
    url: '',
    isTree: true,
    children: [
      {
        title: 'TxProxy Transactions',
        url: '/?project=kikimr&cluster={{cluster}}&service=proxy&host=cluster&dashboard=kikimr-proxy-tx',
        children: [],
        selectors: '',
      },
      {
        title: 'TxProxy Latency',
        url: '/?project=kikimr&cluster={{cluster}}&service=proxy&host=cluster&dashboard=kikimr-proxy-tx-latency',
        children: [],
        selectors: '',
      },
      {
        title: 'DataShard Transactions',
        url: '/?project=kikimr&cluster={{cluster}}&service=tablets&host=cluster&dashboard=kikimr-datashard-tx',
        children: [],
        selectors: '',
      },
      {
        title: 'DataShard Tx Latencies',
        url: '?project=kikimr&cluster={{cluster}}&service=tablets&host=cluster&category=app&type=FLAT_DATASHARD&dashboard=kikimr-tablets-datashard-latency',
        children: [],
        selectors: '',
      },
      {
        title: 'DataShard Own Latencies',
        url: '/?project=kikimr&cluster={{cluster}}&service=tablets&host=cluster&dashboard=kikimr-datashard-tx-latency',
        children: [],
        selectors: '',
      },
      {
        title: 'DataShard Internals',
        url: '/?project=kikimr&cluster={{cluster}}&service=tablets&host=cluster&dashboard=kikimr-datashard-internals',
        children: [],
        selectors: '',
      },
      {
        title: 'Coordinator Counters',
        url: '?project=kikimr&cluster={{cluster}}&service=coordinator&host=cluster&dashboard=kikimr-coordinator-counters',
        children: [],
        selectors: '',
      },
      {
        title: 'Coordinator Latencies',
        url: '?project=kikimr&cluster={{cluster}}&service=coordinator&host=cluster&dashboard=kikimr-coordinator-latencies',
        children: [],
        selectors: '',
      },
      {
        title: 'KQP Query Latency',
        url: '?project=kikimr&cluster={{cluster}}&service=kqp&host=cluster&dashboard=kikimr-kqp-query-latency',
        children: [],
        selectors: '',
      },
      {
        title: 'KQP Queries',
        url: '?project=kikimr&cluster={{cluster}}&service=kqp&host=cluster&dashboard=kikimr-kqp-queries',
        children: [],
        selectors: '',
      },
      {
        title: 'KQP Workers',
        url: '?project=kikimr&cluster={{cluster}}&service=kqp&host=cluster&dashboard=kikimr-kqp-workers',
        children: [],
        selectors: '',
      },
      {
        title: 'Datashard Locks',
        url: '?project=kikimr&cluster={{cluster}}&service=tablets&host=cluster&dashboard=kikimr-datashard-locks',
        children: [],
        selectors: '',
      },
    ],
    selectors: 'project=kikimr&cluster=*',
  },
  {
    title: 'BlobStorage',
    url: '',
    isTree: true,
    children: [
      {
        title: 'Latency Diagnostics',
        url: '/?project={{project}}&cluster={{cluster}}&host=cluster&dashboard=kikimr-diag-bslatency',
        children: [],
        selectors: '',
      },
      {
        title: 'DS Proxy: Response in millisec',
        url: '/?project={{project}}&cluster={{cluster}}&service=kikimr_dsproxy_percentile&host=cluster&blobstorageproxy=2181038081&dashboard=kikimr_kikimr-bsproxy-latency',
        children: [],
        selectors: '',
      },
      {
        title: 'DS Proxy: Active requests',
        url: '/?project={{project}}&cluster={{cluster}}&service=kikimr_dsproxy&host=cluster&blobstorageproxy=*&dashboard=kikimr_kikimr-dsproxy-active-requests',
        children: [],
        selectors: '',
      },
      {
        title: 'Queue',
        url: '/?project=kikimr&cluster={{cluster}}&service=blobstorage&pdisk=total&host=cluster&dashboard=kikimr-bsproxy-queue',
        children: [],
        selectors: '',
      },
      {
        title: 'Interface Messages',
        url: '/?project=kikimr&host=cluster&cluster={{cluster}}&vdisk=total&service=blobstorage&dashboard=kikimr-bs-interface-msgs',
        children: [],
        selectors: '',
      },
      {
        title: 'Device',
        url: '/?project=kikimr&cluster={{cluster}}&service=blobstorage&pdisk=total&host=cluster&dashboard=kikimr-device',
        children: [],
        selectors: '',
      },
      {
        title: 'Yard',
        url: '/?project=kikimr&cluster={{cluster}}&service=blobstorage&pdisk=total&host=cluster&dashboard=kikimr-yard-dashboard',
        children: [],
        selectors: '',
      },
      {
        title: 'Bandwidth',
        url: '/?project=kikimr&cluster={{cluster}}&service=blobstorage&pdisk=total&host=cluster&dashboard=kikimr-blobstorage-bandwidth',
        children: [],
        selectors: '',
      },
      {
        title: 'Repl',
        url: '/?project=kikimr&cluster={{cluster}}&service=blobstorage&host=cluster&graph=kikimr-bs-repl-recovery',
        children: [],
        selectors: '',
      },
      {
        title: 'SyncLog',
        url: '/?project=kikimr&cluster={{cluster}}&service=blobstorage&host=cluster&vdisk=total&dashboard=kikimr-bs-synclog',
        children: [],
        selectors: '',
      },
      {
        title: 'Latencies VDisk',
        url: '/?project=kikimr&cluster={{cluster}}&service=blobstorage&vdisk=total&host=cluster&dashboard=kikimr-blobstorage-latency',
        children: [],
        selectors: '',
      },
      {
        title: 'Latencies PDisk',
        url: '/?project=kikimr&cluster={{cluster}}&service=blobstorage&pdisk=total&host=cluster&dashboard=kikimr-blobstorage-latency-pdisk',
        children: [],
        selectors: '',
      },
      {
        title: 'Queues PDisk',
        url: '/?project=kikimr&cluster={{cluster}}&service=blobstorage&pdisk=total&host=cluster&dashboard=kikimr-blobstorage-queues-pdisk',
        children: [],
        selectors: '',
      },
      {
        title: 'LocalDB Recovery',
        url: '?project=kikimr&cluster={{cluster}}&service=blobstorage&host=cluster&vdisk=total&dashboard=kikimr-localdbrecovery',
        children: [],
        selectors: '',
      },
      {
        title: 'PDisk Chunk Stats',
        url: '?project=kikimr&cluster={{cluster}}&service=blobstorage&host=cluster&pdisk=total&dashboard=kikimr-chunks',
        children: [],
        selectors: '',
      },
      {
        title: 'Syncer Dashboard',
        url: '/?project=kikimr&cluster={{cluster}}&service=blobstorage&host=cluster&dashboard=kikimr-blobstorage-syncer',
        children: [],
        selectors: '',
      },
      {
        title: 'BS Mem Hull',
        url: '/?project=kikimr&cluster={{cluster}}&service=blobstorage&host=cluster&subsystem=memhull&vdisk=total&graph=kikimr-bs-hullmem',
        children: [],
        selectors: '',
      },
      {
        title: 'BS Log Records Dashboard',
        url: '/?project=kikimr&cluster={{cluster}}&service=blobstorage&host=cluster&vdisk=total&dashboard=kikimr-blobstorage-records',
        children: [],
        selectors: '',
      },
      {
        title: 'BS Replication Dashboard',
        url: '?project=kikimr&cluster={{cluster}}&dashboard=kikimr-blobstorage-repl',
        children: [],
        selectors: '',
      },
      {
        title: 'Device 2',
        url: '/?project=kikimr&cluster={{cluster}}&service=pdisks&pdisk=total&host=cluster&dashboard=kikimr-device-2',
        children: [],
        selectors: '',
      },
      {
        title: 'Yard 2',
        url: '/?project=kikimr&cluster={{cluster}}&service=pdisks&pdisk=total&host=cluster&dashboard=kikimr-yard-dashboard-2',
        children: [],
        selectors: '',
      },
      {
        title: 'Bandwidth 2',
        url: '/?project=kikimr&cluster={{cluster}}&service=pdisks&pdisk=total&host=cluster&dashboard=kikimr-blobstorage-bandwidth-2',
        children: [],
        selectors: '',
      },
      {
        title: 'Latencies PDisk 2',
        url: '/?project=kikimr&cluster={{cluster}}&service=pdisks&pdisk=total&host=cluster&dashboard=kikimr-blobstorage-latency-pdisk-2',
        children: [],
        selectors: '',
      },
      {
        title: 'Queues PDisk 2',
        url: '/?project=kikimr&cluster={{cluster}}&service=pdisks&pdisk=total&host=cluster&dashboard=kikimr-blobstorage-queues-pdisk-2',
        children: [],
        selectors: '',
      },
      {
        title: 'PDisk Chunk Stats 2',
        url: '?project=kikimr&cluster={{cluster}}&service=pdisks&host=cluster&pdisk=total&dashboard=kikimr-chunks-2',
        children: [],
        selectors: '',
      },
    ],
    selectors: 'project=kikimr&cluster=*',
  },
  {
    title: 'Interconnect',
    url: '',
    isTree: true,
    children: [
      {
        title: 'Dashboard',
        url: '?project=kikimr&cluster={{cluster}}&service=interconnect&peer=total&host=cluster&dashboard=kikimr_kikimr-interconnect',
        children: [],
        selectors: '',
      },
    ],
    selectors: 'project=kikimr&cluster=*',
  },
  {
    title: 'Tablets',
    url: '',
    isTree: true,
    children: [
      {
        title: 'App Dashboard',
        url: '?project=kikimr&cluster={{cluster}}&service=tablets&type=2&host=cluster&dashboard=kikimr-tablets-app',
        children: [],
        selectors: '',
      },
      {
        title: 'Latency',
        url: '?project=kikimr&cluster={{cluster}}&service=tablets&type=2&host=cluster&dashboard=kiwi-tablets-app-ranges',
        children: [],
        selectors: '',
      },
      {
        title: 'Ranges',
        url: '?project=kikimr&cluster={{cluster}}&service=tablets&type=2&host=cluster&dashboard=kikimr-tablets-app-ranges2',
        children: [],
        selectors: '',
      },
      {
        title: 'LocalDB Latency',
        url: '?project=kikimr&cluster={{cluster}}&service=tablets&type=2&host=cluster&dashboard=kikimr-tablets-localdb-latency',
        children: [],
        selectors: '',
      },
      {
        title: 'Executor',
        url: '?project=kikimr&cluster={{cluster}}&service=tablets&type=2&host=cluster&dashboard=kikimr-tablets-executor',
        children: [],
        selectors: '',
      },
      {
        title: 'Tx Latencies',
        url: '?project=kikimr&cluster={{cluster}}&service=tablets&type=2&host=cluster&dashboard=kikimr-tablets-executor-tx-latency',
        children: [],
        selectors: '',
      },
      {
        title: 'Internal Transactions',
        url: '',
        isTree: true,
        children: [
          {
            title: 'Bytes',
            url: '?project=kikimr&cluster={{cluster}}&service=tablets&host=cluster&category=app&type=FLAT_DATASHARD&graph=kikimr-tablets-datashard-tx-bytes',
            children: [],
            selectors: '',
          },
          {
            title: 'Count',
            url: '?project=kikimr&cluster={{cluster}}&service=tablets&host=cluster&category=app&type=FLAT_DATASHARD&graph=kikimr-tablets-datashard-tx-count',
            children: [],
            selectors: '',
          },
          {
            title: 'Restarts',
            url: '?project=kikimr&cluster={{cluster}}&service=tablets&host=cluster&category=app&type=FLAT_DATASHARD&graph=kikimr-tablets-datashard-tx-restarts',
            children: [],
            selectors: '',
          },
          {
            title: 'Touched Blocks',
            url: '?project=kikimr&cluster={{cluster}}&service=tablets&host=cluster&category=app&type=FLAT_DATASHARD&graph=kikimr-tablets-datashard-tx-blocks',
            children: [],
            selectors: '',
          },
          {
            title: 'Writes',
            url: '?project=kikimr&cluster={{cluster}}&service=tablets&host=cluster&category=app&type=FLAT_DATASHARD&graph=kikimr-tablets-datashard-tx-writes',
            children: [],
            selectors: '',
          },
          {
            title: 'CPU Time',
            url: '?project=kikimr&cluster={{cluster}}&service=tablets&host=cluster&category=app&type=FLAT_DATASHARD&dashboard=kikimr-tablets-datashard-cputime',
            children: [],
            selectors: '',
          },
          {
            title: 'Latencies',
            url: '',
            isTree: true,
            children: [
              {
                title: 'DataShard',
                url: '?project=kikimr&cluster={{cluster}}&service=tablets&host=cluster&category=app&type=FLAT_DATASHARD&dashboard=kikimr-tablets-datashard-latency',
                children: [],
                selectors: '',
              },
            ],
            selectors: '',
          },
        ],
        selectors: '',
      },
      {
        title: 'KeyValue Tablet Summary',
        url: '/?project=kikimr&cluster={{cluster}}&service=tablets&host=cluster&type=KEYVALUEFLAT&category=app&dashboard=kikimr-tablets-keyvalue-summary&b=1d&e=',
        children: [],
        selectors: '',
      },
      {
        title: 'KeyValue Tablet Summary per host aggr',
        url: '/?project=kikimr&cluster={{cluster}}&service=tablets&host=cluster&type=KEYVALUEFLAT&category=app&dashboard=kikimr-tablets-keyvalue-summary-per-host&b=1d&e=',
        children: [],
        selectors: '',
      },
      {
        title: 'KeyValue Tablet Latencies',
        url: '/?project=kikimr&cluster={{cluster}}&service=tablets&host=cluster&type=KEYVALUEFLAT&category=app&dashboard=kikimr-tablets-keyvalue-latency&b=1d&e=',
        children: [],
        selectors: '',
      },
      {
        title: 'KeyValue Tablet Requests/Responses',
        url: '/?project=kikimr&cluster={{cluster}}&service=tablets&host=cluster&type=KEYVALUEFLAT&category=app&dashboard=kikimr-tablets-keyvalue-reqresp&b=1d&e=',
        children: [],
        selectors: '',
      },
      {
        title: 'KeyValue Tablet Cmd',
        url: '/?project=kikimr&cluster={{cluster}}&service=tablets&host=cluster&type=KEYVALUEFLAT&category=app&dashboard=kikimr-tablets-keyvalue-cmd&b=1d&e=',
        children: [],
        selectors: '',
      },
      {
        title: 'PQ Tablet Latencies',
        url: '/?project=kikimr&cluster={{cluster}}&service=tablets&host=cluster&type=PERSQUEUE&category=app&dashboard=kikimr-tablets-keyvalue-latency&b=1d&e=',
        children: [],
        selectors: '',
      },
    ],
    selectors: 'project=kikimr&cluster=*',
  },
  {
    title: 'MsgBus',
    url: '/?project=kikimr&cluster={{cluster}}&host=cluster&service=messagebus&dashboard=kikimr-msgbus',
    children: [],
    selectors: 'project=kikimr&cluster=*',
  },
  {
    title: 'KiWi',
    url: '/?project=kikimr&cluster={{cluster}}&service=kiwi_subscriber&host=cluster&dashboard=kikimr-kiwi-subscriber-overview&b=1h',
    children: [],
    selectors: 'project=kikimr&cluster=kiwi_newsas',
  },
  {
    title: 'KiWi',
    url: '/?project=kikimr&cluster={{cluster}}&service=kiwi_subscriber&host=cluster&dashboard=kikimr-kiwi-subscriber-overview&b=1h',
    children: [],
    selectors: 'project=kikimr&cluster=man',
  },
  {
    title: 'YQL Status',
    url: '/?project=kikimr&cluster=yql&service=yql&dashboard=kikimr-yql-overview',
    children: [],
    selectors: 'project=kikimr&cluster=yql',
  },
  {
    title: 'YQL Usage',
    url: '/?project=kikimr&service=yql&cluster={{cluster}}&dashboard=yql-usage',
    children: [],
    selectors: 'project=kikimr&service=yql&cluster=*',
  },
  {
    title: 'LWTrace',
    url: '',
    isTree: true,
    children: [
      {
        title: 'PDisk',
        url: '/?project=kikimr&cluster={{cluster}}&service=blobstorage&pdisk=000000001&host={{host}}&dashboard=kikimr-blobstorage-lwtrace-pdisk',
        children: [],
        selectors: '',
      },
      {
        title: 'Actor System KikiMR',
        url: '/?project=kikimr&cluster={{cluster}}&service=utils&host={{host}}&dashboard=kikimr-lwtrace-actorsystem',
        children: [],
        selectors: '',
      },
      {
        title: 'Actor System RTMR',
        url: '/?project=rtmr&cluster={{cluster}}&service=utils&host={{host}}&dashboard=kikimr-lwtrace-actorsystem-rtmr',
        children: [],
        selectors: '',
      },
      {
        title: 'Slow Events KikiMR',
        url: '/?project=kikimr&cluster={{cluster}}&service=utils&host={{host}}&dashboard=kikimr-lwtrace-slowevents',
        children: [],
        selectors: '',
      },
      {
        title: 'Slow Events RTMR',
        url: '/?project=rtmr&cluster={{cluster}}&service=utils&host={{host}}&dashboard=kikimr-lwtrace-slowevents-rtmr',
        children: [],
        selectors: '',
      },
      {
        title: 'Interconnect KikiMR',
        url: '/?project=kikimr&cluster={{cluster}}&service=utils&host={{host}}&dashboard=kikimr-lwtrace-interconnect',
        children: [],
        selectors: '',
      },
      {
        title: 'Interconnect RTMR',
        url: '/?project=rtmr&cluster={{cluster}}&service=utils&host={{host}}&dashboard=kikimr-lwtrace-interconnect-rtmr',
        children: [],
        selectors: '',
      },
    ],
    selectors: 'cluster=*&project=kikimr&host=!cluster',
  },
  {
    title: 'Overviews',
    url: '',
    isTree: true,
    children: [
      {
        title: 'Сделать хорошо',
        url: '/?project=kikimr&cluster={{cluster}}&service=blobstorage&host=cluster&dashboard=kikimr-throughput',
        children: [],
        selectors: '',
      },
      {
        title: 'Kikimr KV Store Throughput',
        url: '/?project=kikimr&cluster={{cluster}}&service=blobstorage&host=cluster&dashboard=kikimr-kv-store-throughput',
        children: [],
        selectors: '',
      },
      {
        title: 'Kikimr Data Flow',
        url: '/?project=kikimr&cluster={{cluster}}&service=blobstorage&host=cluster&dashboard=kikimr-data-flow',
        children: [],
        selectors: '',
      },
      {
        title: 'Kikimr Message Flow',
        url: '/?project=kikimr&cluster={{cluster}}&service=blobstorage&host=cluster&dashboard=kikimr-message-flow',
        children: [],
        selectors: '',
      },
      {
        title: 'Kikimr Memory Dashboard',
        url: '/?project=kikimr&cluster={{cluster}}&service=blobstorage&host=cluster&dashboard=kikimr-memory',
        children: [],
        selectors: '',
      },
      {
        title: 'Kikimr CPU Dashboard',
        url: '/?project=kikimr&cluster={{cluster}}&service=blobstorage&host=cluster&dashboard=kikimr-cpu',
        children: [],
        selectors: '',
      },
      {
        title: 'Kikimr Compaction Dashboard',
        url: '/?project=kikimr&cluster={{cluster}}&service=blobstorage&host=cluster&dashboard=kikimr-compaction-overview',
        children: [],
        selectors: '',
      },
      {
        title: 'Kikimr Disks Heatmaps',
        url: '/?project=kikimr&cluster={{cluster}}&hosts=cluster&dashboard=kikimr-disks-heatmaps',
        children: [],
        selectors: '',
      },
    ],
    selectors: 'cluster=*',
  },
  {
    title: 'Go to',
    url: '',
    isTree: true,
    children: [
      {
        title: 'Cluster Viewer',
        url: 'https://kikimr.viewer.yandex-team.ru/{{host}}-main/viewer/#nodes',
        children: [],
        selectors: 'cluster=*&host=*&project=kikimr',
      },
      {
        title: 'Cluster Health',
        url: 'https://kikimr.viewer.yandex-team.ru/{{host}}-main/actors/health',
        children: [],
        selectors: 'cluster=*&host=*&project=kikimr',
      },
      {
        title: 'Kikimr HTTP',
        url: 'https://kikimr.viewer.yandex-team.ru/{{host}}-main/',
        children: [],
        selectors: 'cluster=*&host=*&project=kikimr',
      },
      {
        title: 'PDisk HTTP',
        url: 'https://kikimr.viewer.yandex-team.ru/{{host}}-main/actors/pdisks/pdisk{{pdisk}}',
        children: [],
        selectors: 'cluster=*&host=*&pdisk=*&project=kikimr',
      },
      {
        title: 'VDisk HTTP',
        url: 'https://kikimr.viewer.yandex-team.ru/{{host}}-main/actors/vdisks/vdisk{{vdisk}}',
        children: [],
        selectors: 'cluster=*&host=*&vdisk=*&project=kikimr',
      },
    ],
    selectors: '',
  },
];

const KikimrMenu = () => (
  <MenuEditor treeData={treeData} />
);

export default KikimrMenu;
