import React from 'react';
import PropTypes from 'prop-types';
import TableLegend from '../../pages/data/TableLegend/TableLegend';

function generateDemoRows(count) {
  const rows = [];

  for (let i = 0; i < count; ++i) {
    const r = (Math.random() * 256).toFixed();
    const g = (Math.random() * 256).toFixed();
    const b = (Math.random() * 256).toFixed();
    const color = `rgb(${r},${g},${b})`;

    const value = Math.random() * 1000;
    const formattedValue = value.toFixed(3);

    const row = {
      id: i,
      color,
      names: ['1'],
      values: [value],
      formattedValues: [formattedValue],
    };
    rows.push(row);
  }

  return rows;
}

const TableLegendDemo = ({ count }) => (
  <TableLegend nameTitles={['Metric']} valueTitles={['Value']} rows={generateDemoRows(count)} />
);

TableLegendDemo.propTypes = {
  count: PropTypes.number.isRequired,
};

export default TableLegendDemo;
