import React, { PureComponent } from 'react';
import FormInput from '../../components/forms/FormInput';
import SizeControl from './SizeControl';
import { inputTargetValue } from '../../utils/inputs';
import FlexableSinglestat from '../../components/Tiles/FlexableSinglestat';
import splitLabels from './splitLabels';

class FlexableSinglestatDemo extends PureComponent {
  constructor(props) {
    super(props);
    this.state = {
      labels: 'SENSOR_OVERFLOW', values: '1024', width: 500, height: 500,
    };
  }

  handleInputChange = (event) => {
    const { target } = event;
    const { name } = target;
    this.setState({ [name]: inputTargetValue(target) });
  };

  handleSizeChange = ({ width, height }) => {
    this.setState({ width, height });
  };

  render() {
    const {
      labels, values, width, height,
    } = this.state;
    const labelsList = splitLabels(labels);
    const valuesList = splitLabels(values);

    const tile = {
      labels: labelsList, values: valuesList, url: '', color: 'RED',
    };

    return (
      <div>
        <div className="form-inline">
          <FormInput
            type="text"
            name="labels"
            label="Labels"
            value={labels}
            onChange={this.handleInputChange}
          />
          <FormInput
            type="text"
            name="values"
            label="Values"
            value={values}
            onChange={this.handleInputChange}
          />
        </div>
        <SizeControl width={width} height={height} onSizeChange={this.handleSizeChange} />
        <div className="col-lg-12">
          <div style={{ width, height, border: '1px solid gray ' }}>
            <FlexableSinglestat tile={tile} width={width} height={height} isTargetBlank />
          </div>
        </div>
      </div>
    );
  }
}

export default FlexableSinglestatDemo;
