import React, { PureComponent } from 'react';
import FormInput from '../../components/forms/FormInput';
import FormElement from '../../components/forms/FormElement';
import FlexableTiles from '../../components/Tiles/FlexableTiles';
import SizeControl from './SizeControl';
import { inputTargetValue } from '../../utils/inputs';
import splitLabels from './splitLabels';

class FlexableTilesDemo extends PureComponent {
  constructor(props) {
    super(props);
    this.state = {
      labels: 'SENSOR_OVERFLOW', values: '1024', count: 10, width: 500, height: 500,
    };
  }

  handleInputChange = (event) => {
    const { target } = event;
    const { name } = target;
    this.setState({ [name]: inputTargetValue(target) });
  };

  handleSizeChange = ({ width, height }) => {
    this.setState({ width, height });
  };

  render() {
    const {
      labels, values, count, width, height,
    } = this.state;
    const labelsList = splitLabels(labels);
    const valuesList = splitLabels(values);

    const tiles = [];

    for (let i = 0; i < count; ++i) {
      const tile = {
        labels: labelsList, values: valuesList, url: '', color: 'RED',
      };
      tiles.push(tile);
    }

    return (
      <div>
        <div className="form-inline">
          <FormInput
            type="text"
            name="labels"
            label="Labels"
            value={labels}
            onChange={this.handleInputChange}
          />
          <FormInput
            type="text"
            name="values"
            label="Values"
            value={values}
            onChange={this.handleInputChange}
          />
          <FormElement label="Count">
            <input
              type="number"
              className="form-control"
              name="count"
              max={1000}
              value={count}
              onChange={this.handleInputChange}
            />
          </FormElement>
        </div>
        <SizeControl width={width} height={height} onSizeChange={this.handleSizeChange} />
        <div className="col-lg-12">
          <div style={{ width, height, border: '1px solid gray ' }}>
            <FlexableTiles tiles={tiles} width={width} height={height} isTargetBlank />
          </div>
        </div>
      </div>
    );
  }
}

export default FlexableTilesDemo;
