import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import FormElement from '../../components/forms/FormElement';

class FormInputWithRange extends PureComponent {
  render() {
    const {
      label, name, value, max, min, onChange,
    } = this.props;

    return (
      <FormElement label={label}>
        <div className="col-sm-9">
          <input
            type="range"
            className="form-control"
            name={name}
            max={max}
            min={min}
            value={value}
            onChange={onChange}
          />
        </div>
        <div className="col-sm-3">
          <input
            type="number"
            className="form-control"
            name={name}
            max={max}
            min={min}
            value={value}
            onChange={onChange}
          />
        </div>
      </FormElement>
    );
  }
}

FormInputWithRange.propTypes = {
  label: PropTypes.string.isRequired,
  name: PropTypes.string.isRequired,
  value: PropTypes.number.isRequired,
  max: PropTypes.number.isRequired,
  min: PropTypes.number.isRequired,
  onChange: PropTypes.func.isRequired,
};

export default FormInputWithRange;
