import React, { PureComponent } from 'react';
import FormInput from '../../components/forms/FormInput';
import { inputTargetValue } from '../../utils/inputs';
import Tiles from '../../components/Tiles/Tiles';
import splitLabels from './splitLabels';

class SimpleTilesDemo extends PureComponent {
  constructor(props) {
    super(props);
    this.state = { labels: 'SENSOR_OVERFLOW', values: '1024', count: 10 };
  }

  handleInputChange = (event) => {
    const { target } = event;
    const { name } = target;
    this.setState({ [name]: inputTargetValue(target) });
  };

  render() {
    const { labels, values, count } = this.state;
    const labelsList = splitLabels(labels);
    const valuesList = splitLabels(values);

    const tiles = [];

    for (let i = 0; i < count; ++i) {
      const tile = {
        labels: labelsList, values: valuesList, url: '', color: 'RED',
      };
      tiles.push(tile);
    }

    return (
      <div>
        <div className="form-inline">
          <FormInput
            type="text"
            name="labels"
            label="Labels"
            value={labels}
            onChange={this.handleInputChange}
          />
          <FormInput
            type="text"
            name="values"
            label="Values"
            value={values}
            onChange={this.handleInputChange}
          />
          <FormInput
            type="number"
            name="count"
            label="Count"
            value={count}
            onChange={this.handleInputChange}
          />
        </div>
        <div className="col-lg-12">
          <Tiles tiles={tiles} isTargetBlank />
        </div>
      </div>
    );
  }
}

export default SimpleTilesDemo;
