import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import FormInputWithRange from './FormInputWithRange';

class SizeControl extends PureComponent {
  handleInputChange = (event) => {
    const { target } = event;
    const { name, value } = target;

    let parsedValue = parseInt(value, 10);
    if (isNaN(parsedValue)) {
      parsedValue = 0;
    }

    this.props.onSizeChange({
      width: this.props.width,
      height: this.props.height,
      [name]: parsedValue,
    });
  };

  render() {
    const { width, height } = this.props;

    return (
      <div className="form">
        <FormInputWithRange
          label="Width"
          name="width"
          min={0}
          max={2000}
          value={width}
          onChange={this.handleInputChange}
        />
        <FormInputWithRange
          label="Height"
          name="height"
          min={0}
          max={2000}
          value={height}
          onChange={this.handleInputChange}
        />
      </div>
    );
  }
}

SizeControl.propTypes = {
  width: PropTypes.number.isRequired,
  height: PropTypes.number.isRequired,
  onSizeChange: PropTypes.func.isRequired,
};

export default SizeControl;
