/* eslint-disable jsx-a11y/label-has-for */
import React, { PureComponent } from 'react';
import ReactChartBars from '../../solomon-graph/bars/ReactChartBars';
import { makeAggrData } from './ChartDemoData';

class ChartBarsDemo extends PureComponent {
  constructor(props) {
    super(props);
    this.state = { 'chart-demo-default-values': true };
  }

  handleCheckboxChange = (event) => {
    const { id, checked } = event.target;
    this.setState({ [id]: checked });
  };

  render() {
    const aggrValues = makeAggrData(this.state);

    const conf = { yaxis: { log: false, yaxis: '' }, xaxis: {} };

    conf.yaxis.log = this.state['chart-demo-log'];

    if (this.state['chart-demo-hide-yaxis']) {
      conf.yaxis.yaxis = 'none';
    } else {
      conf.yaxis.yaxis = '';
    }

    let chartBorderWidth;

    if (this.state['chart-demo-wide-border']) {
      chartBorderWidth = 70;
    } else {
      chartBorderWidth = 2;
    }

    const distributionMode = !!this.state['chart-demo-distribution'];

    const graphFormatter = { format: (value) => `${value}` };

    return (
      <div>
        <div id="chart-bars-placeholder" style={{ width: '70%', height: '300px' }}>
          <ReactChartBars
            aggrValues={aggrValues}
            conf={conf}
            chartBorderWidth={chartBorderWidth}
            distributionMode={distributionMode}
            graphFormatter={graphFormatter}
          />
        </div>
        <div>
          <label>
            <input
              type="checkbox"
              id="chart-demo-log"
              checked={this.state['chart-demo-log']}
              onChange={this.handleCheckboxChange}
            />
            {' '}
            Log scale
          </label>
        </div>
        <div>
          <label>
            <input
              type="checkbox"
              id="chart-demo-default-values"
              checked={this.state['chart-demo-default-values']}
              onChange={this.handleCheckboxChange}
            />
            {' '}
            Default values
          </label>
        </div>
        <div>
          <label>
            <input
              type="checkbox"
              id="chart-demo-many-values"
              checked={this.state['chart-demo-many-values']}
              onChange={this.handleCheckboxChange}
            />
            {' '}
            Many values
          </label>
        </div>
        <div>
          <label>
            <input
              type="checkbox"
              id="chart-demo-negative-values"
              checked={this.state['chart-demo-negative-values']}
              onChange={this.handleCheckboxChange}
            />
            {' '}
            Negative values
          </label>
        </div>
        <div>
          <label>
            <input
              type="checkbox"
              id="chart-demo-small-values"
              checked={this.state['chart-demo-small-values']}
              onChange={this.handleCheckboxChange}
            />
            {' '}
            Small values
          </label>
        </div>
        <div>
          <label>
            <input
              type="checkbox"
              id="chart-demo-zero-values"
              checked={this.state['chart-demo-zero-values']}
              onChange={this.handleCheckboxChange}
            />
            {' '}
            Zero values
          </label>
        </div>
        <div>
          <label>
            <input
              type="checkbox"
              id="chart-demo-hide-yaxis"
              checked={this.state['chart-demo-hide-yaxis']}
              onChange={this.handleCheckboxChange}
            />
            {' '}
            Hide Y axis
          </label>
        </div>
        <div>
          <label>
            <input
              type="checkbox"
              id="chart-demo-distribution"
              checked={this.state['chart-demo-distribution']}
              onChange={this.handleCheckboxChange}
            />
            {' '}
            Draw as distribution
          </label>
        </div>
        <div>
          <label>
            <input
              type="checkbox"
              id="chart-demo-wide-border"
              checked={this.state['chart-demo-wide-border']}
              onChange={this.handleCheckboxChange}
            />
            {' '}
            Wide border
          </label>
        </div>
      </div>
    );
  }
}

export default ChartBarsDemo;
