/* eslint-disable no-plusplus,no-restricted-properties */
function makeYaxisConfFromPositionCheckbox(checked) {
  let position;
  if (checked) {
    position = { positionValue: 'right' };
  } else {
    position = { positionValue: 'left' };
  }

  return position;
}

function createLineData() {
  return {
    data: [],
    rawData: [],
    yaxisConf: { positionValue: 'left' },
  };
}

function createAggrData() {
  return {
    show: true,
    value: NaN,
    color: 'blue',
    label: 'unnamed',
    cookie: undefined,
  };
}

export function makeLineData(state) {
  const data = [];

  if (state['chart-demo-default-values']) {
    {
      const d = createLineData();
      d.data.push([101000, 35000, 32000]);
      d.data.push([111000, 38000, 32000]);
      d.data.push([119000, 31000, 30000]);
      d.yaxisConf = makeYaxisConfFromPositionCheckbox(state['chart-demo-lime-to-right']);
      d.color = 'lime';
      d.area = true;
      data.push(d);
    }

    {
      const d = createLineData();
      d.data.push([100000, 30001]);
      d.data.push([105000, 40001]);
      d.data.push([106000, NaN]);
      d.data.push([111000, 36001]);
      d.data.push([120000, 35001]);
      d.yaxisConf = makeYaxisConfFromPositionCheckbox(state['chart-demo-blue-to-right']);
      d.color = 'blue';
      data.push(d);
    }

    {
      const d = createLineData();
      d.data.push([108000, 31500]);
      d.color = 'magenta';
      d.yaxisConf = makeYaxisConfFromPositionCheckbox(state['chart-demo-magenta-to-right']);
      data.push(d);
    }
    {
      const d = createLineData();
      d.data.push([112000, 31000, 34000]);
      d.color = 'orange';
      d.yaxisConf = makeYaxisConfFromPositionCheckbox(state['chart-demo-orange-to-right']);
      d.area = true;
      data.push(d);
    }

    {
      // test drawing by ChartLines Area with zeros
      const d = createLineData();
      d.data.push([104000, 35000, 37000]);
      d.data.push([105000, 39000, 39000]);
      d.data.push([106000, 38000, 39000]);
      d.data.push([107000, 39000, 39000]);
      d.data.push([108000, 39000, 39000]);
      d.data.push([109000, 37000, 39000]);
      d.data.push([110000, 37000, 37000]);
      d.data.push([111000, 36000, 36000]);
      d.data.push([112000, 35000, 35000]);
      d.data.push([115000, 36000, 39000]);
      d.yaxisConf = makeYaxisConfFromPositionCheckbox(state['chart-demo-gray-to-right']);
      d.color = 'gray';
      d.area = true;
      data.push(d);
    }
  }

  if (state['chart-demo-huge-range']) {
    const d = createLineData();
    d.color = 'maroon';
    d.data.push([100000, 0]);
    d.data.push([102000, 3]);
    d.data.push([105000, 40]);
    d.data.push([106000, NaN]);
    d.data.push([111000, 3600]);
    d.data.push([120000, 350010]);
    data.push(d);
  }
  if (state['chart-demo-huge-values']) {
    const d = createLineData();
    d.color = 'maroon';
    d.data.push([100000, 1436435282000.0]);
    d.data.push([102000, 1436435283000.0]);
    d.data.push([105000, 1436435292000.0]);
    d.data.push([106000, NaN]);
    d.data.push([111000, 1436435281000.0]);
    d.data.push([120000, 1436435284000.0]);
    data.push(d);
  }
  if (state['chart-demo-negative-values']) {
    const d = createLineData();
    d.data.push([100000, 35000]);
    d.data.push([103000, 10000]);
    d.data.push([104000, 500]);
    d.data.push([105000, 233]);
    d.data.push([106000, 0]);
    d.data.push([106500, NaN]);
    d.data.push([107000, -0.1]);
    d.data.push([108000, -500]);
    d.data.push([109000, -10000]);
    d.data.push([120000, -35000]);
    d.color = 'red';
    data.push(d);
  }
  if (state['chart-demo-const']) {
    const d = createLineData();
    d.data.push([100000, 10000]);
    d.data.push([120000, 10000]);
    d.color = 'pink';
    data.push(d);
  }
  if (state['chart-demo-zero-values']) {
    const d = createLineData();
    d.data.push([100000, 0]);
    d.data.push([103000, 0]);
    d.data.push([104000, 0]);
    d.data.push([105000, 0]);
    d.data.push([109000, 0]);
    d.data.push([120000, 0]);
    data.push(d);
    d.color = 'red';
  }
  return data;
}

export function makeAggrData(state) {
  const val = state['chart-demo-extra-count'];

  let extraValues;
  if (val) {
    extraValues = parseInt(val, 10);
  } else {
    extraValues = 0;
  }

  const bars = [];

  if (state['chart-demo-large-labels']) {
    let labelPostfix = ' large postfix to test how large labels will be cropped';
    labelPostfix += labelPostfix + labelPostfix + labelPostfix + labelPostfix;

    {
      const v = createAggrData();
      v.value = 15;
      v.color = 'purple';
      bars.push(v);
    }
    {
      const v = createAggrData();
      v.value = 21;
      v.color = 'khaki';
      v.label = `khaki${labelPostfix}`;
      bars.push(v);
    }
    {
      const v = createAggrData();
      v.value = 78;
      v.color = 'darkblue';
      v.label = `darkblue${labelPostfix}`;
      bars.push(v);
    }

    {
      const v = createAggrData();
      v.value = 82;
      v.color = 'darkgrey';
      v.label = `darkgray${labelPostfix}`;
      bars.push(v);
    }
  }

  if (state['chart-demo-default-values']) {
    {
      const v = createAggrData();
      v.value = 10;
      v.color = 'red';
      v.label = 'red; 10';
      v.cookie = 'foo';
      bars.push(v);
    }
    {
      const v = createAggrData();
      v.value = 12;
      v.color = 'yellow';
      v.label = 'yellow; 12';
      v.cookie = 'bar';
      v.link = 'http://www.time.gov/';
      bars.push(v);
    }
    {
      const v = createAggrData();
      v.value = 22;
      v.color = 'black';
      v.label = 'black; 22; invisible';
      v.show = false;
      v.color = 'baz';
      bars.push(v);
    }
    {
      const v = createAggrData();
      v.value = 7;
      v.color = 'green';
      v.label = 'green; 7';
      v.cookie = 'qux';
      bars.push(v);
    }
  }

  if (state['chart-demo-huge-values']) {
    const v = createAggrData();
    v.value = 39000;
    v.color = 'gray';
    v.label = 'gray; 39000; huge';
    v.cookie = 'qux';
    bars.push(v);
  }

  if (state['chart-demo-small-values']) {
    const v = createAggrData();
    v.value = 0.0003;
    v.color = 'orange';
    v.label = 'orange; 0.0003; small';
    v.cookie = 'quux';
    bars.push(v);
  }

  if (state['chart-demo-zero-values']) {
    const v = createAggrData();
    v.value = 0;
    v.color = 'darkgray';
    v.label = 'darkgray; 0; zero';
    v.cookie = 'qux';
    bars.push(v);
  }

  if (state['chart-demo-negative-values']) {
    const v = createAggrData();
    v.value = -7;
    v.color = 'lime';
    v.label = 'lime; -7; negative';
    v.cookie = 'qux';
    bars.push(v);
  }

  if (extraValues > 0) {
    while (extraValues-- > 0) {
      const v = createAggrData();
      v.value = extraValues;
      v.color = 'orange';
      v.label = `lime; ${extraValues}; extra`;
      v.cookie = 'xtr';
      bars.push(v);
    }
  }

  if (state['chart-demo-many-values']) {
    for (let i = 0; i < 900; i++) {
      const v = createAggrData();
      v.value = 10 * Math.pow(Math.sin((i * Math.PI) / 180), 2);
      const labelIndex = (i / 180) + 1;
      v.color = 'lime';
      v.label = `many ${labelIndex}`;
      v.cookie = 'bar';
      bars.push(v);
    }
  }

  return bars;
}
