/* eslint-disable jsx-a11y/label-has-for */
import React, { PureComponent } from 'react';
import ReactChartHeatmap from '../../solomon-graph/heatmap/ReactChartHeatmap';
import { makeAggrData } from './ChartDemoData';

class ChartHeatmapDemo extends PureComponent {
  constructor(props) {
    super(props);
    this.state = { 'chart-demo-default-values': true };
  }

  handleCheckboxChange = (event) => {
    const { id, checked } = event.target;
    this.setState({ [id]: checked });
  };

  handleInputChange = (event) => {
    event.preventDefault();
    const { id, value } = event.target;
    this.setState({ [id]: value });
  };

  render() {
    const aggrValues = makeAggrData(this.state);

    const heatmapColorValues = {
      green: NaN,
      yellow: NaN,
      red: NaN,
      violet: NaN,
    };

    const isLog = !!this.state['chart-demo-log'];

    const conf = {
      heatmapColorValues,
      isLog,
    };

    const graphFormatter = { format: (value) => `${value}` };

    return (
      <div>
        <div className="row">
          <div>
            <label>
              <input
                type="checkbox"
                id="chart-demo-default-values"
                checked={this.state['chart-demo-default-values']}
                onChange={this.handleCheckboxChange}
              />
              {' '}
              Default values
            </label>
          </div>
          <div>
            <label>
              <input
                type="checkbox"
                id="chart-demo-log"
                checked={this.state['chart-demo-log']}
                onChange={this.handleCheckboxChange}
              />
              {' '}
              Log scale
            </label>
          </div>
          <div>
            <label>
              <input
                type="checkbox"
                id="chart-demo-zero-values"
                checked={this.state['chart-demo-zero-values']}
                onChange={this.handleCheckboxChange}
              />
              {' '}
              Zero values
            </label>
          </div>
          <div>
            <label>
              <input
                type="checkbox"
                id="chart-demo-negative-values"
                checked={this.state['chart-demo-negative-values']}
                onChange={this.handleCheckboxChange}
              />
              {' '}
              Negative values
            </label>
          </div>
          <div>
            <label>
              <input
                type="checkbox"
                className="chart-heatmap-demo-reload"
                id="chart-demo-large-labels"
                checked={this.state['chart-demo-large-labels']}
                onChange={this.handleCheckboxChange}
              />
              {' '}
              Large labels
            </label>
          </div>
          <div>
            <label>
              Extra values:
              <input
                type="text"
                placeholder="100"
                id="chart-demo-extra-count"
                value={this.state['chart-demo-extra-count']}
                onChange={this.handleInputChange}
              />
            </label>
          </div>
        </div>
        <div className="row">
          <div id="chart-heatmap-placeholder" style={{ width: '926px', height: '300px' }}>
            <ReactChartHeatmap
              aggrValues={aggrValues}
              conf={conf}
              graphFormatter={graphFormatter}
            />
          </div>
        </div>
      </div>
    );
  }
}

export default ChartHeatmapDemo;
