/* eslint-disable jsx-a11y/label-has-for */
import React, { PureComponent } from 'react';
import ReactChartLines from '../../solomon-graph/lines/ReactChartLines';
import { makeLineData } from './ChartDemoData';

const xaxis = {
  min: 100000,
  max: 120000,
  now: 106000,
  ticks: [[105000, '05'], [110000, '10'], [115000, '15']],
  weekends: [{ begin: 104000, end: 112000 }],
};

class ChartLinesDemo extends PureComponent {
  constructor(props) {
    super(props);
    this.state = {
      'chart-demo-default-values': true,
    };
  }

  handleCheckboxChange = (event) => {
    const { id, checked } = event.target;
    this.setState({ [id]: checked });
  };

  render() {
    const lines = makeLineData(this.state);

    const conf = { yaxis: { log: false, yaxis: '' } };
    conf.xaxis = xaxis;

    conf.yaxis.log = this.state['chart-demo-log'];
    if (this.state['chart-demo-min-max']) {
      conf.yaxis.min = '35000';
      conf.yaxis.max = '36000';
    }
    if (this.state['chart-demo-show-threshold']) {
      conf.threshold = 35000.2;
    }

    const isDatamin = this.state['chart-demo-datamin'];
    if (isDatamin) {
      conf.yaxis.min = 'datamin';
    }

    if (this.state['chart-demo-hide-yaxis']) {
      conf.yaxis.yaxis = 'none';
    } else {
      conf.yaxis.yaxis = '';
    }

    let borderColor;

    if (this.state['chart-demo-colorized-border']) {
      borderColor = 'lightyellow';
    } else {
      borderColor = '';
    }

    let chartBorderWidth;

    if (this.state['chart-demo-wide-border']) {
      chartBorderWidth = 70;
    } else {
      chartBorderWidth = 2;
    }

    const hasMinYaxisAreaWidth = !!this.state['chart-demo-has-min-yaxis-area-width'];

    return (
      <div>
        <div id="chart-placeholder" style={{ width: '70%', height: '300px' }}>
          <ReactChartLines
            lines={lines}
            conf={conf}
            chartBorderWidth={chartBorderWidth}
            hasMinYaxisAreaWidth={hasMinYaxisAreaWidth}
            borderColor={borderColor}
          />
        </div>
        <div>
          <label>
            <input
              type="checkbox"
              id="chart-demo-default-values"
              checked={this.state['chart-demo-default-values']}
              onChange={this.handleCheckboxChange}
            />
            {' '}
            Default values
          </label>
        </div>
        <div>
          <label>
            <input
              type="checkbox"
              id="chart-demo-log"
              checked={this.state['chart-demo-log']}
              onChange={this.handleCheckboxChange}
            />
            {' '}
            Log scale
          </label>
        </div>
        <div>
          <label>
            <input
              type="checkbox"
              id="chart-demo-huge-range"
              checked={this.state['chart-demo-huge-range']}
              onChange={this.handleCheckboxChange}
            />
            {' '}
            Huge range
          </label>
        </div>
        <div>
          <label>
            <input
              type="checkbox"
              id="chart-demo-huge-values"
              checked={this.state['chart-demo-huge-values']}
              onChange={this.handleCheckboxChange}
            />
            {' '}
            Huge values
          </label>
        </div>
        <div>
          <label>
            <input
              type="checkbox"
              id="chart-demo-min-max"
              checked={this.state['chart-demo-min-max']}
              onChange={this.handleCheckboxChange}
            />
            {' '}
            Explicit min-max
          </label>
        </div>
        <div>
          <label>
            <input
              type="checkbox"
              id="chart-demo-datamin"
              checked={this.state['chart-demo-datamin']}
              onChange={this.handleCheckboxChange}
            />
            {' '}
            Set data min
          </label>
        </div>
        <div>
          <label>
            <input
              type="checkbox"
              id="chart-demo-zero-values"
              checked={this.state['chart-demo-zero-values']}
              onChange={this.handleCheckboxChange}
            />
            {' '}
            Zero values
          </label>
        </div>
        <div>
          <label>
            <input
              type="checkbox"
              id="chart-demo-negative-values"
              checked={this.state['chart-demo-negative-values']}
              onChange={this.handleCheckboxChange}
            />
            {' '}
            Negative values
          </label>
        </div>
        <div>
          <label>
            <input
              type="checkbox"
              id="chart-demo-const"
              checked={this.state['chart-demo-const']}
              onChange={this.handleCheckboxChange}
            />
            {' '}
            Const values
          </label>
        </div>
        <div>
          <label>
            <input
              type="checkbox"
              id="chart-demo-lime-to-right"
              checked={this.state['chart-demo-lime-to-right']}
              onChange={this.handleCheckboxChange}
            />
            {' '}
            Lime chart to right axis
          </label>
        </div>
        <div>
          <label>
            <input
              type="checkbox"
              id="chart-demo-gray-to-right"
              checked={this.state['chart-demo-gray-to-right']}
              onChange={this.handleCheckboxChange}
            />
            {' '}
            Gray chart to right axis
          </label>
        </div>
        <div>
          <label>
            <input
              type="checkbox"
              id="chart-demo-blue-to-right"
              checked={this.state['chart-demo-blue-to-right']}
              onChange={this.handleCheckboxChange}
            />
            {' '}
            Blue chart to right axis
          </label>
        </div>
        <div>
          <label>
            <input
              type="checkbox"
              id="chart-demo-magenta-to-right"
              checked={this.state['chart-demo-magenta-to-right']}
              onChange={this.handleCheckboxChange}
            />
            {' '}
            Magenta chart to right axis
          </label>
        </div>
        <div>
          <label>
            <input
              type="checkbox"
              id="chart-demo-orange-to-right"
              checked={this.state['chart-demo-orange-to-right']}
              onChange={this.handleCheckboxChange}
            />
            {' '}
            Orange chart to right axis
          </label>
        </div>
        <div>
          <label>
            <input
              type="checkbox"
              id="chart-demo-show-border"
              checked={this.state['chart-demo-show-border']}
              onChange={this.handleCheckboxChange}
            />
            {' '}
            Show border
          </label>
        </div>
        <div>
          <label>
            <input
              type="checkbox"
              id="chart-demo-show-threshold"
              checked={this.state['chart-demo-show-threshold']}
              onChange={this.handleCheckboxChange}
            />
            {' '}
            Show threshold
          </label>
        </div>
        <div>
          <label>
            <input
              type="checkbox"
              id="chart-demo-has-min-yaxis-area-width"
              checked={this.state['chart-demo-has-min-yaxis-area-width']}
              onChange={this.handleCheckboxChange}
            />
            {' '}
            Show min yaxis area width
          </label>
        </div>
        <div>
          <label>
            <input
              type="checkbox"
              id="chart-demo-hide-yaxis"
              checked={this.state['chart-demo-hide-yaxis']}
              onChange={this.handleCheckboxChange}
            />
            {' '}
            Hide Y axis
          </label>
        </div>
        <div>
          <label>
            <input
              type="checkbox"
              id="chart-demo-colorized-border"
              checked={this.state['chart-demo-colorized-border']}
              onChange={this.handleCheckboxChange}
            />
            {' '}
            Colorized backbround
          </label>
        </div>
        <div>
          <label>
            <input
              type="checkbox"
              id="chart-demo-wide-border"
              checked={this.state['chart-demo-wide-border']}
              onChange={this.handleCheckboxChange}
            />
            {' '}
            Wide border
          </label>
        </div>
      </div>
    );
  }
}

export default ChartLinesDemo;
