/* eslint-disable jsx-a11y/label-has-for */
import React, { PureComponent } from 'react';
import ReactChartLines from '../../solomon-graph/lines/ReactChartLines';

const xaxis = {
  min: 100000,
  max: 120000,
  now: 106000,
  ticks: [[105000, '05'], [110000, '10'], [115000, '15']],
  weekends: [{ begin: 104000, end: 112000 }],
};

function makeLineData() {
  const data = [];

  for (let i = 0; i < 100; ++i) {
    const d = { show: true, data: [] };

    for (let j = 100000, ji = 0; j < 120000; j += 20, ji += 1) {
      const prevYHigh = i === 0 ? 0 : data[data.length - 1].data[ji][2];
      const curValue = Math.random() * 10;

      d.data.push([j, prevYHigh, prevYHigh + curValue]);
    }

    d.yaxisConf = { positionValue: 'left' };
    d.color = 'lime';
    d.area = true;

    data.push(d);
  }

  return data;
}

class ChartLinesPerfDemo extends PureComponent {
  constructor(props) {
    super(props);
    this.state = {
      'chart-demo-default-values': true,
    };
  }

  render() {
    const lines = makeLineData(this.state);

    const conf = { yaxis: { log: false, yaxis: '' } };
    conf.xaxis = xaxis;

    return (
      <div>
        <div id="chart-placeholder" style={{ width: '70%', height: '300px' }}>
          <ReactChartLines
            lines={lines}
            conf={conf}
            chartBorderWidth={2}
            hasMinYaxisAreaWidth={false}
            borderColor=""
            debug
          />
        </div>
      </div>
    );
  }
}

export default ChartLinesPerfDemo;
