/* eslint-disable jsx-a11y/label-has-for */
import React, { PureComponent } from 'react';
import ReactChartPie from '../../solomon-graph/pie/ReactChartPie';
import { makeAggrData } from './ChartDemoData';

class ChartPieDemo extends PureComponent {
  constructor(props) {
    super(props);
    this.state = { 'chart-demo-default-values': true };
  }

  handleCheckboxChange = (event) => {
    const { id, checked } = event.target;
    this.setState({ [id]: checked });
  };

  handleInputChange = (event) => {
    event.preventDefault();
    const { id, value } = event.target;
    this.setState({ [id]: value });
  };

  render() {
    const aggrValues = makeAggrData(this.state);

    let height;
    if (this.state['chart-demo-small-height']) {
      height = '150px';
    } else {
      height = '300px';
    }

    const graphFormatter = { format: (value) => `${value}` };

    return (
      <div>
        <div id="chart-pie-placeholder" style={{ width: '70%', height }}>
          <ReactChartPie aggrValues={aggrValues} graphFormatter={graphFormatter} />
        </div>
        <div>
          <label>
            <input
              type="checkbox"
              id="chart-demo-default-values"
              checked={this.state['chart-demo-default-values']}
              onChange={this.handleCheckboxChange}
            />
            {' '}
            Default values
          </label>
        </div>
        <div>
          <label>
            <input
              type="checkbox"
              id="chart-demo-zero-values"
              checked={this.state['chart-demo-zero-values']}
              onChange={this.handleCheckboxChange}
            />
            {' '}
            Zero values
          </label>
        </div>
        <div>
          <label>
            <input
              type="checkbox"
              id="chart-demo-negative-values"
              checked={this.state['chart-demo-negative-values']}
              onChange={this.handleCheckboxChange}
            />
            {' '}
            Negative values
          </label>
        </div>
        <div>
          <label>
            <input
              type="checkbox"
              className="chart-pie-demo-reload"
              id="chart-demo-large-labels"
              checked={this.state['chart-demo-large-labels']}
              onChange={this.handleCheckboxChange}
            />
            {' '}
            Large labels
          </label>
        </div>
        <div>
          <label>
            <input
              type="checkbox"
              id="chart-demo-small-height"
              checked={this.state['chart-demo-small-height']}
              onChange={this.handleCheckboxChange}
            />
            {' '}
            Small height
          </label>
        </div>
        <div>
          <label>
            Extra values:
            <input
              type="text"
              placeholder="100"
              id="chart-demo-extra-count"
              value={this.state['chart-demo-extra-count']}
              onChange={this.handleInputChange}
            />
          </label>
        </div>
      </div>
    );
  }
}

export default ChartPieDemo;
