import UrlUtils from './url/UrlUtils';

class BrowserUtils {
  static getLogicalUrlAfterHost() {
    return window.location.pathname + window.location.search;
  }

  static location() {
    return `${window.location}`;
  }

  static locationHref() {
    return window.location.href;
  }

  static userAgent() {
    return window.navigator.userAgent;
  }

  static reloadPage() {
    window.location.reload(true);
  }

  static setLocationHref(href) {
    window.location.href = href;
  }

  static setTopLocationHref(href) {
    window.top.location.href = href;
  }

  static inIframe() {
    // If you want to rewrite this using locations (why???), be aware:
    // Reading `top.location` into string yields PermissionDeined
    // when in iframe on another host, however comparison seems to be OK.
    return window.top !== window.self;
  }

  static getTopLocationHref() {
    // JS SecurityError occurs when accessing top document on different protocol, domain or port.
    return window.top.location.href;
  }

  static getLogicalQueryArgsMap() {
    return UrlUtils.parseUrlQueryArgs(BrowserUtils.getLogicalUrlAfterHost());
  }

  static getLogicalQueryArgOrEmpty(name) {
    return UrlUtils.parseUrl(BrowserUtils.getLogicalUrlAfterHost())
      .getLogicalQueryArgOrEmpty(name);
  }

  static isLocalHost() {
    const { hostname } = window.location;
    return hostname === 'localhost' || hostname === '127.0.0.1';
  }
}

export default BrowserUtils;
