const pattern = /^([+\-0-9.]+)([kmgtp])$/i;
const numberPattern = /^[+\-0-9.eE]+$/;

/**
 * Parse number text with kmg suffix
 *
 * @param {string} text
 * @return {number} parsed number
 */
function parseKmg(text) {
  const match = pattern.exec(text.trim().toLowerCase());
  if (match !== null) {
    let multiplier;

    const prefix = parseFloat(match[1]);
    const suffix = match[match.length - 1].toLowerCase();
    if (suffix === 'k') {
      multiplier = 1000;
    } else if (suffix === 'm') {
      multiplier = 1000 * 1000;
    } else if (suffix === 'g') {
      multiplier = 1000 * 1000 * 1000;
    } else if (suffix === 't') {
      multiplier = 1000 * 1000 * 1000 * 1000;
    } else if (suffix === 'p') {
      multiplier = 1000 * 1000 * 1000 * 1000 * 1000;
    } else {
      throw new Error('unreachable');
    }
    return prefix * multiplier;
  }

  const numMatch = numberPattern.test(text.trim());
  if (!numMatch) {
    return NaN;
  }
  return parseFloat(text);
}

export default parseKmg;
